/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.dictionary;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.client.command.dictionary.CommandDictionary;
import com.diquest.ir.client.util.JobDescription;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.dictionary.ThesaurusDictionary;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.ByteT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandThesaurus
extends CommandDictionary {
    public static final String ANY_COLLECTION = "";
    public static final String ANY_PROFILE = "";
    private static final String KEYWORD_DELIMITER = "\n";
    private static final String THESAURUS_DELIMITER = "\t";
    public byte thesaurusID = 0;

    public CommandThesaurus(AdminServerClient client, String userid) {
        super(client, userid);
    }

    public CommandThesaurus(AdminServerClient client, String userid, byte thesaurusID) {
        super(client, userid);
        this.thesaurusID = thesaurusID;
    }

    public boolean applyImpl(String collectionID, String profileID, String profileKey) throws IRException {
        return this.applyImpl(collectionID, profileID, profileKey, this.thesaurusID);
    }

    public boolean applyImpl(String collectionID, String profileID, String profileKey, byte thesaurusID) throws IRException {
        JobDescription description = new JobDescription("applying Thesaurus Dictionary " + profileKey);
        DataT data = new DataT(3);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        data.put("thesaurusID", (Transmitable)new ByteT(thesaurusID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.thesaurus.ExtMessageJobApplyThesaurus", (Transmitable)data);
        return this.client.registerJob(request, description, this.userid);
    }

    public boolean applySystemThesaurus(ThesaurusDictionary dic) {
        DataT data = new DataT(1);
        data.put("dictionary", (Transmitable)dic);
        return true;
    }

    public String[] getSystemThesaurus(String key, String collectionID) throws IRException {
        String result = this.getThesaurus(key, collectionID, "", true);
        String[] thesauruses = result.split(KEYWORD_DELIMITER);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < thesauruses.length) {
            buffer.append(thesauruses[i]);
            buffer.append(THESAURUS_DELIMITER);
            ++i;
        }
        return buffer.toString().split(THESAURUS_DELIMITER);
    }

    public String[] getSystemThesaurus(String key, String collectionID, String profileID) throws IRException {
        String result = this.getThesaurus(key, collectionID, profileID, true);
        String[] thesauruses = result.split(KEYWORD_DELIMITER);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < thesauruses.length) {
            buffer.append(thesauruses[i]);
            buffer.append(THESAURUS_DELIMITER);
            ++i;
        }
        return buffer.toString().split(THESAURUS_DELIMITER);
    }

    public String getThesaurus(String key) throws IRException {
        return this.getThesaurus(key, "", "", false);
    }

    public String getThesaurus(String key, String collectionID) throws IRException {
        return this.getThesaurus(key, collectionID, "", false);
    }

    public String getThesaurus(String key, String collectionID, String profileID) throws IRException {
        return this.getThesaurus(key, collectionID, profileID, false);
    }

    public String getThesaurus(String key, String collectionID, String profileID, boolean isSystem) throws IRException {
        DataT data = new DataT(5);
        data.put("key", (Transmitable)new StringT(key));
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        data.put("thesaurusID", (Transmitable)new ByteT(this.thesaurusID));
        data.put("isSystem", (Transmitable)new BooleanT(isSystem));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.dictionary.thesaurus.ExtMessageThesaurus", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        DataT dataT = (DataT)response.getData();
        StringT thesauruses = (StringT)dataT.get("thesaurus");
        return thesauruses.value;
    }
}

