/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.feedback;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.database.entity.feedback.FeedbackStatisticEntity;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.feedback.RequestFeedbackStatisticsData;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;

public class CommandFeedbackDataRequest {
    private final String ip;
    private final int port;
    private FeedbackStatisticEntity statisticsEntities;

    public CommandFeedbackDataRequest(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int request(RequestFeedbackStatisticsData requestData) throws IRException {
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.feedback.ExtMessageFeedbackDataRequest", (Transmitable)requestData);
        ExternalClientPool targetPool = ExternalClientPool.getInstance(this.ip, this.port);
        ExtResponse response = targetPool.invoke(request, targetPool.getPoolWaitTimeout());
        if (response == null) {
            return -60000;
        }
        if (response.getErrorCode() > -100) {
            this.statisticsEntities = (FeedbackStatisticEntity)response.getData();
            return 0;
        }
        return response.getErrorCode();
    }

    public static boolean setProps(String ip, int port, int poolWaitTimeout, int minPoolSize, int maxPoolSize) {
        return ExternalClientPool.getInstance(ip, port).setProps(poolWaitTimeout, minPoolSize, maxPoolSize);
    }

    public FeedbackStatisticEntity getStatistics() {
        return this.statisticsEntities;
    }
}

