/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.feedback;

import com.diquest.ir.client.command.feedback.CollectionProfile;
import com.diquest.ir.client.command.feedback.CommandFeedback;
import com.diquest.ir.client.command.feedback.FeedbackThread;
import com.diquest.ir.client.command.feedback.PrintThread;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FeedbackApp {
    public static String ip;
    public static int port;
    public static long maxSleepTime;
    public static int numThread;
    public static String kFilename;
    public static String cFilename;
    public static long runTime;
    public static List keywords;
    public static List collections;
    public static int keywordSizeLimit;
    public static boolean printInfo;
    public static int keywordPos;
    public static int feedbackCnt;
    public static long startTime;
    public static boolean isdebug;

    static {
        keywordSizeLimit = 50000;
        printInfo = false;
        keywordPos = 0;
        feedbackCnt = 0;
        startTime = 0L;
        isdebug = false;
    }

    public static void makeKeywords(String filename) throws IOException {
        keywords = new ArrayList();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = reader.readLine();
        int keywordCount = 0;
        while (line != null) {
            keywords.add(line.trim());
            line = reader.readLine();
            if (++keywordCount % 1000 == 0) {
                System.out.print("keywordCount = " + keywordCount + "\n");
            }
            if (keywordCount >= keywordSizeLimit) break;
        }
        reader.close();
    }

    public static void makeCollectionProfile(String cFilename) throws IOException {
        collections = new ArrayList();
        BufferedReader reader = new BufferedReader(new FileReader(cFilename));
        String line = reader.readLine();
        while (line != null) {
            String[] colProfile = line.trim().split("\t");
            if (colProfile.length > 1) {
                collections.add(new CollectionProfile(colProfile[0], colProfile[1]));
            } else {
                collections.add(new CollectionProfile(colProfile[0], null));
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public static final synchronized String nextKeyword() {
        if (System.currentTimeMillis() - startTime > runTime * 1000L) {
            return null;
        }
        if (printInfo) {
            if (++feedbackCnt % 5000 == 0) {
                System.out.print("[feedback count = " + feedbackCnt + "]" + "[" + (System.currentTimeMillis() - startTime) / 1000L + "s / " + runTime / 1000L + "s]\n");
            }
        } else {
            ++feedbackCnt;
        }
        String keyword = (String)keywords.get(keywordPos++);
        if (keywordPos >= keywords.size()) {
            keywordPos = 0;
        }
        return keyword;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        ip = args[0].trim();
        port = Integer.parseInt(args[1].trim());
        runTime = Integer.parseInt(args[2].trim()) * 1000 * 60;
        maxSleepTime = Integer.parseInt(args[3].trim());
        numThread = Integer.parseInt(args[4].trim());
        kFilename = args[5].trim();
        cFilename = args[6].trim();
        if (args.length >= 8) {
            boolean bl = printInfo = Integer.parseInt(args[7].trim()) == 1;
        }
        if (args.length >= 9) {
            boolean bl = isdebug = Integer.parseInt(args[8].trim()) == 1;
        }
        if (args.length >= 10) {
            keywordSizeLimit = Integer.parseInt(args[9].trim());
        }
        FeedbackApp.makeKeywords(kFilename);
        FeedbackApp.makeCollectionProfile(cFilename);
        CommandFeedback.setProps(ip, port, 5000, numThread, numThread);
        startTime = System.currentTimeMillis();
        FeedbackThread[] threads = new FeedbackThread[numThread];
        int i = 0;
        while (i < threads.length) {
            threads[i] = new FeedbackThread(i, ip, port, runTime, maxSleepTime);
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            threads[i].start();
            ++i;
        }
        PrintThread pt = new PrintThread(threads, runTime);
        pt.start();
        int i2 = 0;
        while (i2 < threads.length) {
            threads[i2].join();
            ++i2;
        }
        pt.join();
    }
}

