/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.feedback;

import com.diquest.ir.client.command.feedback.CollectionProfile;
import com.diquest.ir.client.command.feedback.FeedbackApp;
import com.diquest.ir.client.command.feedback.impl.CommandKeywordFeedback;
import com.diquest.ir.common.database.entity.feedback.FeedbackKeywordEntity;
import com.diquest.ir.common.database.handler.feedback.FeedbackKeywordDB;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.feedback.FeedbackMethods;
import com.diquest.ir.common.msg.feedback.Feedback;
import com.diquest.ir.common.msg.feedback.impl.UsabilityFeedback;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Random;

class FeedbackThread
extends Thread {
    private Random random;
    private String ip;
    private int port;
    private long aliveTime;
    private long qtotalResponseTime = 0L;
    public int qcount = 0;
    private long maxSleepTime;

    public static String[] makeKeywordList() {
        FeedbackKeywordEntity[] entities = null;
        String[] keywords = null;
        try {
            Connection conn = ConnectionFactory.getConnection();
            entities = FeedbackKeywordDB.excuteSelect((Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (entities != null && entities.length > 0) {
            keywords = new String[entities.length];
            int i = 0;
            int end = entities.length;
            while (i < end) {
                keywords[i] = entities[i].getKeyword();
                ++i;
            }
        }
        return keywords;
    }

    public FeedbackThread(int seq, String ip, int port, long aliveTime, long maxSleepTime) {
        this.setName("FeedbackThread - " + seq);
        this.ip = ip;
        this.port = port;
        this.aliveTime = aliveTime;
        this.maxSleepTime = maxSleepTime;
        this.random = new Random(System.currentTimeMillis());
    }

    private void getFeedback() throws IRException {
        String keyword = FeedbackApp.nextKeyword();
        String function = this.choose(FeedbackMethods.FUNCTION_IDS, 20);
        CollectionProfile cp = this.choose(FeedbackApp.collections, FeedbackApp.collections.size());
        long st = System.currentTimeMillis();
        UsabilityFeedback feedback = new UsabilityFeedback(function, cp.getCollection(), cp.getProfile(), keyword);
        int rc = CommandKeywordFeedback.getFeedback(this.ip, this.port, (Feedback)feedback);
        if (rc < 0) {
            System.out.println("ERROR (getFeedback): " + rc);
        }
        if (FeedbackApp.isdebug) {
            StringBuffer sb = new StringBuffer(70);
            sb.append("Function[ ").append(function).append(" ], ");
            sb.append("Collection[ ").append(cp.getCollection()).append(" ], ");
            sb.append("Profile[ ").append(cp.getProfile()).append(" ], ");
            sb.append("Keyword[ ").append(keyword).append(" ]\n");
            System.out.print(sb.toString());
        }
        long ed = System.currentTimeMillis();
        this.qtotalResponseTime += ed - st;
        ++this.qcount;
    }

    private String choose(String[] list, int size) {
        int choose = this.random.nextInt(size);
        return list[choose];
    }

    private CollectionProfile choose(List collections, int size) {
        int choose = this.random.nextInt(size);
        return (CollectionProfile)collections.get(choose);
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        Random rand = new Random();
        long sleep = this.maxSleepTime == 0L ? 0L : rand.nextLong() % this.maxSleepTime;
        try {
            while (System.currentTimeMillis() - startTime < this.aliveTime) {
                sleep = Math.abs(sleep);
                Thread.sleep(sleep);
                this.getFeedback();
                sleep = this.maxSleepTime == 0L ? 0L : rand.nextLong() % this.maxSleepTime;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IRException e) {
            e.printStackTrace();
        }
    }
}

