/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.feedback;

import com.diquest.ir.client.command.feedback.FeedbackApp;
import com.diquest.ir.client.command.feedback.FeedbackThread;

class PrintThread
extends Thread {
    private FeedbackThread[] threads;
    private long runtime;

    public PrintThread(FeedbackThread[] threads, long runtime) {
        this.threads = threads;
        this.runtime = runtime;
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer(50);
        int total = 0;
        while (System.currentTimeMillis() - startTime < this.runtime) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int totalFeedbackCount = 0;
            int i = 0;
            while (i < this.threads.length) {
                totalFeedbackCount += this.threads[i].qcount;
                ++i;
            }
            int elipsed = (int)((System.currentTimeMillis() - startTime) / 1000L);
            if (!FeedbackApp.isdebug) continue;
            sb.setLength(0);
            sb.append("COUNT = ").append(totalFeedbackCount).append("\t");
            sb.append("feedback/sec = ").append((double)totalFeedbackCount / (double)elipsed).append("\t");
            sb.append("elipsed = ").append(elipsed).append("sec.\n");
            System.out.print(sb.toString());
        }
        int i = 0;
        while (i < this.threads.length) {
            total += this.threads[i].qcount;
            ++i;
        }
        sb.setLength(0);
        sb.append("Total Count = ").append(total).append("\t");
        sb.append("feedback/sec = ").append((double)total / (double)(this.runtime / 1000L)).append("\t");
        sb.append("time = ").append(this.runtime / 1000L).append("\n");
        System.out.print(sb.toString());
    }
}

