/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.profile;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.msg.collection.CollectionInfo;
import com.diquest.ir.common.msg.collection.DefaultProfileInfo;
import com.diquest.ir.common.msg.collection.ProfileInfo;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandProfile {
    private final AdminServerClient client;

    public CommandProfile(AdminServerClient client) {
        this.client = client;
    }

    public CommandProfile(String ip, int port) {
        this.client = new AdminServerClient(ip, port);
    }

    public CollectionInfo[] getAllCollectionInfo() throws IRException {
        return this.getCollectionInformation("");
    }

    public CollectionInfo getCollectionInfo(String collectionID) throws IRException {
        return this.getCollectionInformation(collectionID)[0];
    }

    private CollectionInfo[] getCollectionInformation(String collectionID) throws IRException {
        if (collectionID == null) {
            collectionID = "";
        }
        DataT data = new DataT(1);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageGetProfileList", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        ArrayT result = (ArrayT)response.getData();
        Transmitable[] tr = result.value;
        CollectionInfo[] info = new CollectionInfo[tr.length];
        int i = 0;
        while (i < tr.length) {
            info[i] = (CollectionInfo)tr[i];
            ++i;
        }
        return info;
    }

    public ProfileInfo getProfileInfo(String collectionID, String profileID) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot get profileInfo : CollectionID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        if (StringUtil.isEmpty((String)profileID)) {
            throw new IRException(2, "Cannot get profileInfo : profileID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageGetProfile", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        ProfileInfo result = (ProfileInfo)response.getData();
        return result;
    }

    public DefaultProfileInfo getDefaultProfileInfo(String collectionID) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot get Profile Default Setting Information : collectionID is null.");
        }
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(""));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageGetProfile", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        DefaultProfileInfo result = (DefaultProfileInfo)response.getData();
        return result;
    }

    public boolean addProfile(String collectionID, String profileID, ProfileInfo profileInfo) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot add Profile : collectionID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        if (StringUtil.isEmpty((String)profileID)) {
            throw new IRException(2, "Cannot add Profile : profileID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        if (profileInfo == null) {
            throw new IRException(2, "Cannot add Profile : profileInfo is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        DataT data = new DataT(3);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        data.put("profileSetting", (Transmitable)profileInfo);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageAddProfile", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        return response.getErrorCode() >= 0;
    }

    public boolean updateProfile(String collectionID, String profileID, ProfileInfo profileInfo) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot update Profile Setting : collectionID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        if (StringUtil.isEmpty((String)profileID)) {
            throw new IRException(2, "Cannot update Profile Setting : profileID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        if (profileInfo == null) {
            throw new IRException(2, "Cannot update Profile Setting : profileInfo is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        DataT data = new DataT(3);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        data.put("profileSetting", (Transmitable)profileInfo);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageUpdateProfile", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        return response.getErrorCode() >= 0;
    }

    public boolean updateDefaultProfile(String collectionID, DefaultProfileInfo profileInfo) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot update Default Profile Setting : collectionID is null.", ProfileKey.getKey((String)collectionID));
        }
        if (profileInfo == null) {
            throw new IRException(2, "Cannot update Default Profile Setting : profileInfo is null.", ProfileKey.getKey((String)collectionID));
        }
        DataT data = new DataT(3);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(""));
        data.put("profileSetting", (Transmitable)profileInfo);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageUpdateProfile", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        return response.getErrorCode() >= 0;
    }

    public boolean updateDefaultProfileFirst(String collectionID, DefaultProfileInfo profileInfo) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot update Default Profile Setting : collectionID is null.", ProfileKey.getKey((String)collectionID));
        }
        if (profileInfo == null) {
            throw new IRException(2, "Cannot update Default Profile Setting : profileInfo is null.", ProfileKey.getKey((String)collectionID));
        }
        DataT data = new DataT(3);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(""));
        data.put("profileSetting", (Transmitable)profileInfo);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageUpdateProfileFirst", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        return response.getErrorCode() >= 0;
    }

    public boolean removeProfile(String collectionID, String profileID) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot remove Profile : collectionID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        if (StringUtil.isEmpty((String)profileID)) {
            throw new IRException(2, "Cannot remove Profile : profileID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageRemoveProfile", (Transmitable)data);
        ExtResponse response = this.client.invoke(request);
        return response.getErrorCode() >= 0;
    }
}

