/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.profile;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.msg.collection.CollectionInfo;
import com.diquest.ir.common.msg.collection.DefaultProfileInfo;
import com.diquest.ir.common.msg.collection.ProfileInfo;
import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.StringT;

public class CommandProfileSearch {
    private String ip;
    private int port;

    public CommandProfileSearch(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public CollectionInfo[] getAllCollectionInfo() throws IRException {
        return this.getCollectionInformation("");
    }

    public CollectionInfo getCollectionInfo(String collectionID) throws IRException {
        return this.getCollectionInformation(collectionID)[0];
    }

    private CollectionInfo[] getCollectionInformation(String collectionID) throws IRException {
        if (collectionID == null) {
            collectionID = "";
        }
        DataT data = new DataT(1);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageGetProfileList", (Transmitable)data);
        ExternalClientPool targetPool = ExternalClientPool.getInstance(this.ip, this.port);
        ExtResponse response = targetPool.invoke(request, targetPool.getPoolWaitTimeout());
        ArrayT result = (ArrayT)response.getData();
        Transmitable[] tr = result.value;
        CollectionInfo[] info = new CollectionInfo[tr.length];
        int i = 0;
        while (i < tr.length) {
            info[i] = (CollectionInfo)tr[i];
            ++i;
        }
        return info;
    }

    public ProfileInfo getProfileInfo(String collectionID, String profileID) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot get profileInfo : CollectionID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        if (StringUtil.isEmpty((String)profileID)) {
            throw new IRException(2, "Cannot get profileInfo : profileID is null.", ProfileKey.getKey((String)collectionID, (String)profileID));
        }
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(profileID));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageGetProfile", (Transmitable)data);
        ExternalClientPool targetPool = ExternalClientPool.getInstance(this.ip, this.port);
        ExtResponse response = targetPool.invoke(request, targetPool.getPoolWaitTimeout());
        ProfileInfo result = (ProfileInfo)response.getData();
        return result;
    }

    public DefaultProfileInfo getDefaultProfileInfo(String collectionID) throws IRException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new IRException(2, "Cannot get Profile Default Setting Information : collectionID is null.");
        }
        DataT data = new DataT(2);
        data.put("collectionID", (Transmitable)new StringT(collectionID));
        data.put("profileID", (Transmitable)new StringT(""));
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.setting.profile.ExtMessageGetProfile", (Transmitable)data);
        ExternalClientPool targetPool = ExternalClientPool.getInstance(this.ip, this.port);
        ExtResponse response = targetPool.invoke(request, targetPool.getPoolWaitTimeout());
        DefaultProfileInfo result = (DefaultProfileInfo)response.getData();
        return result;
    }
}

