/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.command.report;

import com.diquest.ir.client.command.AdminServerClient;
import com.diquest.ir.common.database.report.cache.Constraint;
import com.diquest.ir.common.database.report.cache.IndexLogDbConstraint;
import com.diquest.ir.common.database.report.cache.IndexReportCache;
import com.diquest.ir.common.database.report.cache.ServerLogDbConstraint;
import com.diquest.ir.common.database.report.cache.ServerReportCache;
import com.diquest.ir.common.database.report.cache.StatisticalQueryLogDbConstraint;
import com.diquest.ir.common.database.report.cache.StatisticalQueryReportCache;
import com.diquest.ir.common.msg.ext.body.report.CacheKeyComponents;
import com.diquest.ir.common.report.IndexReport;
import com.diquest.ir.common.report.ServerReport;
import com.diquest.ir.common.report.StatisticalQueryReport;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.BooleanT;
import java.sql.Connection;
import java.sql.SQLException;

public class CommandReport {
    private static final long CACHING_THRESHOLD = 2000000L;
    final AdminServerClient client;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CommandReport(AdminServerClient client) {
        this.client = client;
    }

    public synchronized StatisticalQueryReport getStatisticalQueryReport(Connection conn, long from, long to, long unit, String[] servers, String[] collections, String[][] profiles) throws SQLException {
        StatisticalQueryReport report;
        StatisticalQueryLogDbConstraint constraint = StatisticalQueryLogDbConstraint.of((String[])collections, (String[][])profiles, (String[])servers, (long)from, (long)to);
        long localTime = StatisticalQueryReportCache.getInstance().getTime((Constraint)constraint);
        if (localTime != Long.MIN_VALUE && (report = (StatisticalQueryReport)StatisticalQueryReportCache.getInstance().get((Constraint)constraint)) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.diquest.ir.common.database.report.cache.StatisticalQueryReportCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.isValid(clazz, (Constraint)constraint, localTime)) {
                return report;
            }
        }
        long started = System.currentTimeMillis();
        StatisticalQueryReport report2 = new StatisticalQueryReport(conn, from, to, unit, servers, collections, profiles);
        long registered = System.currentTimeMillis();
        if (registered - started > 2000000L) {
            StatisticalQueryReportCache.getInstance().put((Constraint)constraint, (Object)report2, registered);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.diquest.ir.common.database.report.cache.StatisticalQueryReportCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.register(clazz, (Constraint)constraint, registered);
        }
        return report2;
    }

    public synchronized IndexReport getIndexReport(Connection conn, long from, long to, long unit) throws SQLException {
        return this.getIndexReport(conn, from, to, unit, null);
    }

    public synchronized IndexReport getIndexReport(Connection conn, long from, long to, long unit, String[] collections) throws SQLException {
        IndexReport report;
        IndexLogDbConstraint constraint = IndexLogDbConstraint.of((String[])collections, (long)from, (long)to);
        long localTime = IndexReportCache.getInstance().getTime((Constraint)constraint);
        if (localTime != Long.MIN_VALUE && (report = (IndexReport)IndexReportCache.getInstance().get((Constraint)constraint)) != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.diquest.ir.common.database.report.cache.IndexReportCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.isValid(clazz, (Constraint)constraint, localTime)) {
                return report;
            }
        }
        long started = System.currentTimeMillis();
        IndexReport report2 = new IndexReport(conn, from, to, unit, collections);
        long registered = System.currentTimeMillis();
        if (registered - started > 2000000L) {
            IndexReportCache.getInstance().put((Constraint)constraint, (Object)report2, registered);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.diquest.ir.common.database.report.cache.IndexReportCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.register(clazz, (Constraint)constraint, registered);
        }
        return report2;
    }

    public synchronized ServerReport getServerReport(Connection conn, long from, long to, long unit) throws SQLException {
        return this.getServerReport(conn, from, to, unit, (String[])null);
    }

    public synchronized ServerReport getServerReport(Connection conn, long from, long to, long unit, String server) throws SQLException {
        return this.getServerReport(conn, from, to, unit, new String[]{server});
    }

    public synchronized ServerReport getServerReport(Connection conn, long from, long to, long unit, String[] servers) throws SQLException {
        ServerReport report;
        ServerLogDbConstraint constraint = ServerLogDbConstraint.of((String[])servers, (long)from, (long)to);
        long localTime = ServerReportCache.getInstance().getTime((Constraint)constraint);
        if (localTime != Long.MIN_VALUE && (report = (ServerReport)ServerReportCache.getInstance().get((Constraint)constraint)) != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("com.diquest.ir.common.database.report.cache.ServerReportCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.isValid(clazz, (Constraint)constraint, localTime)) {
                return report;
            }
        }
        long started = System.currentTimeMillis();
        ServerReport report2 = new ServerReport(conn, from, to, unit, servers);
        long registered = System.currentTimeMillis();
        if (registered - started > 2000000L) {
            ServerReportCache.getInstance().put((Constraint)constraint, (Object)report2, registered);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("com.diquest.ir.common.database.report.cache.ServerReportCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.register(clazz, (Constraint)constraint, registered);
        }
        return report2;
    }

    private boolean isValid(Class clazz, Constraint constraint, long timeOf) {
        try {
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.report.ExtMessageIsValidCacheConstraint", (Transmitable)new CacheKeyComponents(clazz, constraint, timeOf));
            ExtResponse response = this.client.invoke(request);
            if (response != null && response.getErrorCode() >= 0) {
                BooleanT data = (BooleanT)response.getData();
                return data != null && data.value;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean register(Class clazz, Constraint constraint, long timeOf) {
        try {
            ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.report.ExtMessageRegisterCacheConstraint", (Transmitable)new CacheKeyComponents(clazz, constraint, timeOf));
            ExtResponse response = this.client.invoke(request);
            if (response != null && response.getErrorCode() >= 0) {
                BooleanT data = (BooleanT)response.getData();
                return data != null && data.value;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

