/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.common;

import com.diquest.ir.client.network.ExternalClientWorker;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.common.msg.ext.body.common.ServerKey;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;

public class ServerRestartCommand {
    private String serverManagerIP;
    private int serverManagerPort;

    public ServerRestartCommand(String serverManagerIP, int serverManagerPort) {
        this.serverManagerIP = serverManagerIP;
        this.serverManagerPort = serverManagerPort;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            System.out.println("[" + args[i] + "][" + args[i].length() + "]");
            ++i;
        }
        String serverManagerIp = args[0];
        int serverManagerPort = Integer.parseInt(args[1]);
        char serverGroup = args[2].toUpperCase().charAt(0);
        int serverId = 0;
        System.out.println("restarting...");
        if (serverGroup != 'A' && serverGroup != 'S' && serverGroup != 'B') {
            System.out.println("Unknown server group [" + (char)serverGroup + "]");
            System.exit(-1);
        }
        try {
            serverId = Integer.parseInt(args[3]);
        }
        catch (NumberFormatException e) {
            System.out.println("Unsupported server ID [" + args[3] + "]");
            System.exit(-1);
        }
        ServerRestartCommand client = new ServerRestartCommand(serverManagerIp, serverManagerPort);
        try {
            client.restart(serverGroup, serverId);
            System.out.println("Server restarted successfully.");
        }
        catch (IRException e) {
            System.out.println("Fail to send restart message.");
            System.out.println(e.getLocalMessage());
            System.out.println(e.getRawTraceText());
        }
    }

    public void restart(int group, int id) throws IRException {
        ServerKey body = new ServerKey(group, id);
        ExtRequest request = new ExtRequest("com.diquest.ir.mgr.msg.WDMessageRestartServer", (Transmitable)body);
        ExtResponse response = null;
        try {
            System.out.print("Sending message to restart Server[Group=" + (char)group + " ID=" + id + "] ...");
            response = this.invoke(request, this.serverManagerIP, this.serverManagerPort);
            System.out.println("Send success.");
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot restart server[Group=" + group + " ID=" + id + "]. " + "An Exception is occurred during sending a message to ServerManager[ip:" + this.serverManagerIP + ",port:" + this.serverManagerPort + "]", (Throwable)e);
        }
        if (response.getErrorCode() < 0) {
            ErrorMessage error = (ErrorMessage)response.getData();
            throw new IRException(2, "Cannot restart server[Group=" + group + " ID=" + id + "]. " + error.getErrorMessage());
        }
    }

    private ExtResponse invoke(ExtRequest request, String ip, int port) throws IRException {
        ExternalClientWorker worker = new ExternalClientWorker(ip, port);
        ExtResponse response = null;
        try {
            response = worker.invoke(request);
        }
        catch (Exception e) {
            throw new IRException(2, "Cannot send a message to ServerManager[ip:" + this.serverManagerIP + ",port:" + this.serverManagerPort + "]", (Throwable)e);
        }
        return response;
    }
}

