/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.checker;

import com.diquest.ir.client.dic.checker.DictionaryCheckResult;
import com.diquest.ir.util.common.StringLineReader;
import com.diquest.ir.util.common.StringUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;

public abstract class DictionaryChecker {
    private final String FORMAT_ERROR = "FORMAT_ERROR";
    private final String DUPLICATION = "DUPLICATION";
    private final char BOPEN = (char)40;
    private final char BCLOSE = (char)41;
    private StringLineReader reader;
    private HashSet set = new HashSet();
    protected String delimiter;
    private int totalSize = 0;
    private int normalSize = 0;
    private int duplication = 0;
    private int formatError = 0;
    private boolean useErrorComment;
    private StringBuffer errorBuf;

    public DictionaryChecker(StringLineReader reader, String delimiter, boolean useErrorComment) {
        this.delimiter = delimiter;
        this.reader = reader;
        this.useErrorComment = useErrorComment;
        if (useErrorComment) {
            this.errorBuf = new StringBuffer();
        }
    }

    public abstract boolean checkFormat(String var1);

    public boolean checkDuplication(String key) {
        if (this.set.contains(key)) {
            return false;
        }
        this.set.add(key);
        return true;
    }

    private String getKey(String line) {
        if (line.length() == 0) {
            return null;
        }
        int sepIndex = line.indexOf(this.delimiter);
        if (sepIndex < 0) {
            return line;
        }
        if (sepIndex == 0) {
            return null;
        }
        return line.substring(0, sepIndex).toUpperCase();
    }

    private void writeError(String error, int line, String value) {
        this.errorBuf.append(line);
        this.errorBuf.append(':');
        this.errorBuf.append(error);
        this.errorBuf.append(' ');
        this.errorBuf.append(value);
        this.errorBuf.append('\n');
    }

    public DictionaryCheckResult check() throws IOException {
        String line = this.reader.readLine();
        boolean isErr = false;
        int lineCount = 1;
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                ++this.totalSize;
                String key = this.getKey(line);
                if (key == null) {
                    isErr = true;
                    ++this.formatError;
                    if (this.useErrorComment) {
                        this.writeError("FORMAT_ERROR", lineCount, line);
                    }
                }
                if (key != null && !this.checkDuplication(key)) {
                    isErr = true;
                    ++this.duplication;
                    if (this.useErrorComment) {
                        this.writeError("DUPLICATION", lineCount, line);
                    }
                }
                if (!this.checkFormat(line)) {
                    isErr = true;
                    ++this.formatError;
                    if (this.useErrorComment) {
                        this.writeError("FORMAT_ERROR", lineCount, line);
                    }
                }
                if (!isErr) {
                    ++this.normalSize;
                }
                isErr = false;
            }
            ++lineCount;
            line = this.reader.readLine();
        }
        return new DictionaryCheckResult(this.totalSize, this.normalSize, this.formatError, this.duplication, this.errorBuf.toString());
    }

    public int getDuplication() {
        return this.duplication;
    }

    public int getFormatError() {
        return this.formatError;
    }

    protected boolean hasEmpty(String input) {
        char[] inputArray = input.toCharArray();
        int i = 0;
        while (i < inputArray.length) {
            if (this.isWhite(inputArray[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isWhite(char c) {
        return c <= ' ' && (c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\u0000');
    }

    protected String[] makeKeys(String line) {
        line = StringUtil.removeWhitespaces((String)line).toUpperCase();
        String[] keys = line.split(this.delimiter);
        return this.refine(keys);
    }

    private String[] refine(String[] keys) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        int i = 0;
        while (i < keys.length) {
            set.add(keys[i]);
            ++i;
        }
        if (set.size() == keys.length) {
            return keys;
        }
        String[] newKeys = new String[set.size()];
        set.toArray(newKeys);
        return newKeys;
    }
}

