/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.checker;

import com.diquest.commons.type.DateUtil;
import com.diquest.ir.client.dic.checker.DictionaryChecker;
import com.diquest.ir.util.common.StringLineReader;

public class RedirectChecker
extends DictionaryChecker {
    public RedirectChecker(StringLineReader reader, String delimiter, boolean useErrorComment) {
        super(reader, delimiter, useErrorComment);
    }

    public boolean checkFormat(String line) {
        String[] keys = line.split(this.delimiter);
        if (keys[0].length() > 50) {
            return false;
        }
        if (keys[1].length() > 255) {
            return false;
        }
        if (keys[2].length() > 4000) {
            return false;
        }
        if (keys[3].length() > 32) {
            return false;
        }
        if (keys.length < 4) {
            return false;
        }
        if (keys.length > 6) {
            return false;
        }
        if (keys.length >= 5 && !keys[4].trim().equals("0") && !DateUtil.isValidDate((String)keys[4].trim())) {
            return false;
        }
        return keys.length != 6 || keys[5].trim().equals("0") || DateUtil.isValidDate((String)keys[5].trim());
    }
}

