/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.download;

import com.diquest.ir.client.dic.download.DictionaryDownloader;
import com.diquest.ir.common.database.entity.profile.thesaurus.Thesaurus;
import com.diquest.ir.common.database.handler.dictionary.ThesaurusDB;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

public class ThesaurusDownloader
extends DictionaryDownloader {
    private byte thesaurusID;

    private ThesaurusDownloader(Connection conn, String collectionID, String profileID) {
        super(conn, collectionID, profileID);
    }

    public ThesaurusDownloader(Connection conn, String collectionID, String profileID, byte thesaurusID) {
        super(conn, collectionID, profileID);
        this.thesaurusID = thesaurusID;
    }

    public int writeLine(BufferedWriter writer, String delimiter) throws IOException, SQLException {
        int total = ThesaurusDB.getCount((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (byte)this.thesaurusID);
        int start = 1;
        int scale = 10000;
        boolean isFinished = false;
        while (!isFinished) {
            Thesaurus[] list = ThesaurusDB.getListPage((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (byte)this.thesaurusID, (int)start, (int)scale, (String)"KEYWORD ASC");
            int i = 0;
            while (i < list.length) {
                writer.write(list[i].getKeyword());
                String[] synonyms = list[i].getKeywords();
                int r = 0;
                while (r < synonyms.length) {
                    writer.write(delimiter);
                    writer.write(synonyms[r]);
                    ++r;
                }
                writer.write(10);
                ++i;
            }
            if ((start += scale) > total) {
                start = total;
            }
            System.out.println("download = " + start + "/" + total);
            if (start != total) continue;
            isFinished = true;
        }
        return total;
    }
}

