/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.upload;

import com.diquest.ir.client.dic.upload.DictionaryUploader;
import com.diquest.ir.common.database.entity.profile.categoryranking.CategoryRanking;
import com.diquest.ir.common.database.entity.profile.categoryranking.CategoryRankingKeyword;
import com.diquest.ir.common.database.handler.dictionary.CategoryRankingDB;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.SQLException;

public class CategoryRankingUploader
extends DictionaryUploader {
    public CategoryRankingUploader(Connection conn, String collectionID, String profileID, BufferedReader reader, String delimiter) {
        super(conn, collectionID, profileID, reader, delimiter);
    }

    public boolean checkFormat(String line) {
        String[] keys = line.split(this.delimiter);
        if (keys.length != 9) {
            return false;
        }
        if (!(keys[3].equals("1") || keys[3].equals("2") || keys[3].equals("3"))) {
            return false;
        }
        if (!keys[7].equals("0") && !keys[7].equals("1")) {
            return false;
        }
        return keys[8].equals("U") || keys[8].equals("S");
    }

    public boolean checkDuplication(String key) {
        return true;
    }

    protected void upload(String line) throws SQLException {
        String[] keys = line.split(this.delimiter);
        String keyword = keys[0];
        String field = keys[1];
        String category = keys[2];
        int type = Integer.parseInt(keys[3]);
        int rank = Integer.parseInt(keys[4]);
        long start = Long.parseLong(keys[5]);
        long end = Long.parseLong(keys[6]);
        char use = keys[7].charAt(0);
        char creator = keys[8].charAt(0);
        CategoryRankingDB.deleteCategory((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword, (String)field, (String)category, (char)creator);
        CategoryRanking categoryRanking = new CategoryRanking(this.collectionID, this.profileID, keyword, field, category, (byte)type, rank, start, end, 0L, false, use == '1', creator);
        CategoryRankingDB.putCategory((Connection)this.conn, (CategoryRanking)categoryRanking);
        CategoryRankingKeyword categoryRankingKeyword = CategoryRankingDB.getKeyword((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword);
        int categories = CategoryRankingDB.getCountCategory((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword);
        if (categoryRankingKeyword == null) {
            CategoryRankingDB.putKeyword((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword, (int)categories);
        } else {
            CategoryRankingDB.updateKeyword((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword, (int)categories);
        }
    }
}

