/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.upload;

import com.diquest.ir.client.dic.checker.DictionaryCheckResult;
import com.diquest.ir.util.common.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashSet;

public abstract class DictionaryUploader {
    private BufferedReader reader;
    private HashSet set;
    protected String delimiter;
    protected Connection conn;
    protected String collectionID;
    protected String profileID;

    public DictionaryUploader(Connection conn, String collectionID, String profileID, BufferedReader reader, String delimiter) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.set = new HashSet();
        this.delimiter = delimiter;
        this.reader = reader;
        this.conn = conn;
    }

    public abstract boolean checkFormat(String var1);

    protected abstract void upload(String var1) throws SQLException;

    public boolean checkDuplication(String key) {
        if (this.set.contains(key)) {
            return false;
        }
        this.set.add(key);
        return true;
    }

    private String getKey(String line) {
        if (line.length() == 0) {
            return null;
        }
        int sepIndex = line.indexOf(this.delimiter);
        if (sepIndex < 0) {
            return line;
        }
        if (sepIndex == 0) {
            return null;
        }
        return line.substring(0, sepIndex).toUpperCase();
    }

    public DictionaryCheckResult upload() throws IOException, SQLException {
        String line = this.reader.readLine();
        boolean isErr = false;
        int totalSize = 0;
        int formatError = 0;
        int duplication = 0;
        int normalSize = 0;
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                ++totalSize;
                String key = this.getKey(line);
                if (key == null) {
                    isErr = true;
                    ++formatError;
                }
                if (key != null && !this.checkDuplication(key)) {
                    isErr = true;
                    ++duplication;
                }
                if (!this.checkFormat(line)) {
                    isErr = true;
                    ++formatError;
                }
                if (!isErr) {
                    ++normalSize;
                    try {
                        this.upload(line);
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                    }
                }
                isErr = false;
            }
            line = this.reader.readLine();
        }
        return new DictionaryCheckResult(totalSize, normalSize, formatError, duplication, null);
    }

    protected boolean hasEmpty(String input) {
        char[] inputArray = input.toCharArray();
        int i = 0;
        while (i < inputArray.length) {
            if (this.isWhite(inputArray[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isWhite(char c) {
        return c <= ' ' && (c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\u0000');
    }

    protected String[] makeKeys(String line) {
        line = StringUtil.removeWhitespaces((String)line).toUpperCase();
        String[] keys = line.split(this.delimiter);
        return this.refine(keys);
    }

    protected String[] makeRealKeys(String line) {
        line = StringUtil.removeWhitespaces((String)line);
        String[] keys = line.split(this.delimiter);
        return this.refine(keys);
    }

    private String[] refine(String[] keys) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        int i = 0;
        while (i < keys.length) {
            set.add(keys[i]);
            ++i;
        }
        if (set.size() == keys.length) {
            return keys;
        }
        String[] newKeys = new String[set.size()];
        set.toArray(newKeys);
        return newKeys;
    }
}

