/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.upload;

import com.diquest.ir.client.dic.upload.DictionaryUploader;
import com.diquest.ir.common.database.entity.profile.documentranking.DocumentRanking;
import com.diquest.ir.common.database.entity.profile.documentranking.DocumentRankingKeyword;
import com.diquest.ir.common.database.handler.dictionary.DocumentRankingDB;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.SQLException;

public class DocumentRankingUploader
extends DictionaryUploader {
    public DocumentRankingUploader(Connection conn, String collectionID, String profileID, BufferedReader reader, String delimiter) {
        super(conn, collectionID, profileID, reader, delimiter);
    }

    public boolean checkFormat(String line) {
        String[] keys = line.split(this.delimiter);
        if (keys.length != 6) {
            return false;
        }
        return keys[2].equals("1") || keys[2].equals("2") || keys[2].equals("3");
    }

    public boolean checkDuplication(String key) {
        return true;
    }

    protected void upload(String line) throws SQLException {
        String[] keys = line.split(this.delimiter);
        String keyword = keys[0];
        String docID = keys[1];
        int type = Integer.parseInt(keys[2]);
        int rank = Integer.parseInt(keys[3]);
        long start = Long.parseLong(keys[4]);
        long end = Long.parseLong(keys[5]);
        DocumentRankingDB.deleteDocumentRanking((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword, (String)docID);
        DocumentRanking documentRanking = new DocumentRanking(this.collectionID, this.profileID, keyword, docID, (byte)type, rank, start, end, 0L, false);
        DocumentRankingDB.putDocument((Connection)this.conn, (DocumentRanking)documentRanking);
        DocumentRankingKeyword documentRankingKeyword = DocumentRankingDB.getKeyword((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword);
        int documents = DocumentRankingDB.getCountDocumentRanking((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword);
        if (documentRankingKeyword == null) {
            DocumentRankingDB.putKeyword((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword, (int)documents);
        } else {
            DocumentRankingDB.updateKeyword((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword, (int)documents);
        }
    }
}

