/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.upload;

import com.diquest.commons.type.DateUtil;
import com.diquest.ir.client.dic.upload.DictionaryUploader;
import com.diquest.ir.common.database.handler.dictionary.RedirectDB;
import com.diquest.ir.util.common.StringUtil;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.SQLException;

public class RedirectUploader
extends DictionaryUploader {
    public RedirectUploader(Connection conn, String collectionID, String profileID, BufferedReader reader, String delimiter) {
        super(conn, collectionID, profileID, reader, delimiter);
    }

    public boolean checkFormat(String line) {
        String[] keys = (line = line.toUpperCase()).split(this.delimiter);
        if (keys[0].length() > 50) {
            return false;
        }
        if (keys[1].length() > 255) {
            return false;
        }
        if (keys[2].length() > 4000) {
            return false;
        }
        if (keys[3].length() > 32) {
            return false;
        }
        if (keys.length < 4) {
            return false;
        }
        if (keys.length > 6) {
            return false;
        }
        if (keys.length >= 5 && !keys[4].trim().equals("0") && !DateUtil.isValidDate((String)keys[4].trim())) {
            return false;
        }
        return keys.length != 6 || keys[5].trim().equals("0") || DateUtil.isValidDate((String)keys[5].trim());
    }

    public void upload(String line) throws SQLException {
        String[] keys = line.split(this.delimiter);
        String themeTitle = keys[0].trim().toUpperCase();
        String keyword = keys[1].trim().toUpperCase();
        String url = keys[2].trim();
        url = StringUtil.simpleHTML2Text((String)url);
        String author = keys[3].trim();
        long startDate = 0L;
        long endDate = 0L;
        if (keys.length >= 5 && !String.valueOf(keys[4].trim()).equals("0")) {
            startDate = DateUtil.getDateMillis((String)keys[4].trim());
        }
        if (keys.length >= 6 && !String.valueOf(keys[5].trim()).equals("0")) {
            endDate = DateUtil.getDateMillis((String)keys[5].trim());
        }
        RedirectDB.deleteTheme((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)themeTitle);
        RedirectDB.put((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (String)keyword, (String)themeTitle, (String)author, (long)startDate, (long)endDate, (String)url);
    }
}

