/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.dic.upload;

import com.diquest.ir.client.dic.upload.DictionaryUploader;
import com.diquest.ir.common.database.handler.dictionary.ThesaurusDB;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.SQLException;

public class ThesaurusUploader
extends DictionaryUploader {
    private byte thesaurusID;

    public ThesaurusUploader(Connection conn, String collectionID, String profileID, BufferedReader reader, String delimiter) {
        super(conn, collectionID, profileID, reader, delimiter);
    }

    public ThesaurusUploader(Connection conn, String collectionID, String profileID, byte thesaurusID, BufferedReader reader, String delimiter) {
        super(conn, collectionID, profileID, reader, delimiter);
        this.thesaurusID = thesaurusID;
    }

    public boolean checkFormat(String line) {
        String[] keys = this.makeKeys(line);
        if (keys.length < 2) {
            return false;
        }
        if (keys[0].length() > 50) {
            return false;
        }
        if (line.length() - keys[0].length() - 1 > 255) {
            return false;
        }
        int i = 0;
        while (i < keys.length) {
            if (keys[i].trim().length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void upload(String line) throws SQLException {
        String[] keys = this.makeKeys(line);
        String[] thesauruses = new String[keys.length - 1];
        System.arraycopy(keys, 1, thesauruses, 0, keys.length - 1);
        ThesaurusDB.delete((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (byte)this.thesaurusID, (String)keys[0]);
        ThesaurusDB.put((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (byte)this.thesaurusID, (String)keys[0], (String[])thesauruses);
    }

    public void uploadFullDuplex(String line) throws SQLException {
        String[] keys = this.makeKeys(line);
        String[] thesauruses = new String[keys.length - 1];
        System.arraycopy(keys, 1, thesauruses, 0, keys.length - 1);
        ThesaurusDB.delete((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (byte)this.thesaurusID, (String)keys[0]);
        ThesaurusDB.putFullDuplex((Connection)this.conn, (String)this.collectionID, (String)this.profileID, (byte)this.thesaurusID, (String)keys[0], (String[])thesauruses);
    }
}

