/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.log.display;

import com.diquest.ir.client.util.ChartProperties;
import com.diquest.ir.client.util.EasyTimeSeries;
import com.diquest.ir.common.database.handler.LogTimeSliceDB;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class LogTimeSliceDBDisplay {
    protected JFreeChart chart;
    Date[] domains;
    double[][] counts;
    double[][] averageResponseTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.diquest.ir.client.log.display.LogTimeSliceDBDisplay");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public double[][] getCounts() {
        return this.counts;
    }

    public double[][] getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public Date[] getDomains() {
        return this.domains;
    }

    public LogTimeSliceDBDisplay(Date from, Date to, int displayUnit, int realUnit, String[] collections) throws SQLException {
        if (!$assertionsDisabled && collections.length == 0) {
            throw new AssertionError();
        }
        List[] timeSlicedQueryData = LogTimeSliceDBDisplay.getTimeSlicedQueryData(from, to, displayUnit, realUnit, collections);
        LogTimeSliceChartProperties chartProperties = new LogTimeSliceChartProperties();
        chartProperties.setAxisLabels(new String[]{"Query Count", "Average Response Time (milliseconds)"});
        chartProperties.setChartTitle("Query Log Statistics");
        chartProperties.setDomainLabel("Time");
        Object[][][] countPlots = new Object[collections.length][2][];
        Object[][][] artPlots = new Object[collections.length][2][];
        this.domains = new Date[timeSlicedQueryData[0].size()];
        this.counts = new double[collections.length][timeSlicedQueryData[0].size()];
        this.averageResponseTime = new double[collections.length][timeSlicedQueryData[0].size()];
        int c = 0;
        while (c < collections.length) {
            List collectionLogs = timeSlicedQueryData[c];
            int collectionSlots = collectionLogs.size();
            Date[] domain = new Date[collectionSlots];
            countPlots[c][0] = domain;
            artPlots[c][0] = domain;
            Double[] counts = new Double[collectionSlots];
            countPlots[c][1] = counts;
            Double[] arts = new Double[collectionSlots];
            artPlots[c][1] = arts;
            Iterator iterator = collectionLogs.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Object[] logEntity = (Object[])iterator.next();
                domain[index] = (Date)logEntity[0];
                counts[index] = (Double)logEntity[1];
                this.counts[c][index] = counts[index];
                arts[index] = (Double)logEntity[2];
                this.averageResponseTime[c][index] = arts[index];
                ++index;
                iterator.remove();
            }
            if (c == 0) {
                System.arraycopy(domain, 0, this.domains, 0, domain.length);
            }
            ++c;
        }
        Object[][][][] plotValues = new Object[][][][]{countPlots, artPlots};
        chartProperties.setPlotValues(plotValues);
        String[][] seriesLabels = new String[][]{(String[])collections.clone(), (String[])collections.clone()};
        int i = 0;
        while (i < seriesLabels[0].length) {
            String[] stringArray = seriesLabels[0];
            int n = i++;
            stringArray[n] = String.valueOf(stringArray[n]) + " Count";
        }
        i = 0;
        while (i < seriesLabels[1].length) {
            String[] stringArray = seriesLabels[1];
            int n = i++;
            stringArray[n] = String.valueOf(stringArray[n]) + " ART";
        }
        chartProperties.setSeriesLabels(seriesLabels);
        chartProperties.setTimeTick((long)displayUnit * 1000L * 60L);
        LogTimeSliceTimeSeries logTimeSliceTimeSeries = new LogTimeSliceTimeSeries(chartProperties);
        this.chart = logTimeSliceTimeSeries.getChart();
    }

    public void saveChartAsJPEG(File file, int width, int height) throws IOException {
        ChartUtilities.saveChartAsJPEG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
    }

    public void saveChartAsPNG(File file, int width, int height) throws IOException {
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
    }

    public static List[] getTimeSlicedQueryData(Date from, Date to, int unit, int knownGap, String[] collections) throws SQLException {
        LogTimeSliceDB client = new LogTimeSliceDB();
        List[] slottedData = new List[collections.length];
        List[] naiveCollectionsData = client.getTimeSlicedQueryData(from, to, collections);
        if (unit <= 0) {
            unit = 60;
        }
        long interval = (long)unit * 1000L * 60L;
        int i = 0;
        while (i < collections.length) {
            List naiveData = naiveCollectionsData[i];
            int naiveSize = naiveData.size();
            long fromTime = LogTimeSliceDBDisplay.correct(from, unit, true).getTime();
            long toTime = LogTimeSliceDBDisplay.correct(to, unit, false).getTime();
            ArrayList<Object[]> slots = new ArrayList<Object[]>((int)(1L + (toTime - fromTime) / interval));
            int naiveIndex = 0;
            long time = fromTime;
            while (time <= toTime) {
                double sum = 0.0;
                double avg = 0.0;
                long logGap = 0L;
                while (naiveIndex < naiveSize) {
                    Object[] log = (Object[])naiveData.get(naiveIndex);
                    long logTime = ((Date)log[0]).getTime();
                    if (naiveIndex + 1 < naiveSize) {
                        long nextLogTime = ((Date)((Object[])naiveData.get(naiveIndex + 1))[0]).getTime();
                        logGap = nextLogTime - logTime;
                    } else if (knownGap == 0) {
                        if (logGap == 0L) {
                            logGap = time + interval - logTime;
                        }
                    } else {
                        logGap = knownGap;
                    }
                    if (logTime >= time + interval) break;
                    double logCount = (Double)log[1];
                    double logAvg = (Double)log[2];
                    double portion = LogTimeSliceDBDisplay.portionOfOverlap(time, interval, logTime, logGap);
                    sum += logCount * portion;
                    avg += logCount * portion * logAvg;
                    if (logTime + logGap >= time + interval) break;
                    ++naiveIndex;
                }
                Object[] slot = new Object[]{new Date(time), new Double(sum), new Double(sum == 0.0 ? 0.0 : avg / sum)};
                slots.add(slot);
                time += interval;
            }
            slottedData[i] = slots;
            naiveData.clear();
            naiveCollectionsData[i] = null;
            ++i;
        }
        return slottedData;
    }

    private static double portionOfOverlap(long srcFrom, long srcLength, long destFrom, long destLength) {
        if (srcLength <= 0L || destLength <= 0L) {
            return 0.0;
        }
        long srcEnd = srcFrom + srcLength;
        long destEnd = destFrom + destLength;
        if (destEnd <= srcFrom) {
            return 0.0;
        }
        if (srcEnd <= destFrom) {
            return 0.0;
        }
        if (destEnd <= srcEnd) {
            srcEnd = destEnd;
        }
        if (srcFrom <= destFrom) {
            srcFrom = destFrom;
        }
        return (double)(srcEnd - srcFrom) / (double)(destEnd - destFrom);
    }

    public static Date correct(Date date, int minute, boolean before) {
        long MINUTE = 60000L;
        long shift = 32400000L;
        if (before) {
            long time = date.getTime();
            long overed = (time + shift) % ((long)minute * MINUTE);
            return new Date(time - overed);
        }
        long time = date.getTime();
        long overed = (time + shift) % ((long)minute * MINUTE);
        if (overed != 0L) {
            time = time - overed + (long)minute * MINUTE;
        }
        return new Date(time);
    }

    class LogTimeSliceChartProperties
    extends ChartProperties {
        private static final long serialVersionUID = -2146057384664733069L;

        LogTimeSliceChartProperties() {
        }

        public double getRangeHigh(double min, double max) {
            return Math.max((max + 1.0) * 1.2, 10.0);
        }

        public double getRangeLow(double min, double max) {
            return 0.0;
        }

        public SimpleDateFormat getFormat(Class timePeriodClass) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jfree.data.time.Minute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(timePeriodClass)) {
                return new SimpleDateFormat("MM/dd HH:mm");
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.jfree.data.time.Hour");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isAssignableFrom(timePeriodClass)) {
                return new SimpleDateFormat("MM/dd HH");
            }
            return new SimpleDateFormat("MM/dd");
        }
    }

    class LogTimeSliceTimeSeries
    extends EasyTimeSeries {
        private static final int COUNT_DATASET = 0;
        private static final int ART_DATASET = 1;

        public LogTimeSliceTimeSeries(ChartProperties prop) {
            super(prop);
        }

        protected void decorateChart(ChartProperties prop) {
            XYPlot plot = this.chart.getXYPlot();
            DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
            int numSeries = prop.getNumSeries(0);
            Paint[] colors = new Paint[numSeries];
            int i = 0;
            while (i < colors.length) {
                Paint nextPaint;
                colors[i] = nextPaint = drawingSupplier.getNextPaint();
                ++i;
            }
            int d = 0;
            while (d < prop.getNumDataset()) {
                XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
                renderer.setShapesVisible(true);
                renderer.setShapesFilled(true);
                int s = 0;
                while (s < numSeries) {
                    renderer.setSeriesPaint(s, colors[s]);
                    if (d == 0) {
                        renderer.setSeriesStroke(s, (Stroke)new BasicStroke(2.0f));
                    } else if (d == 1) {
                        float[] dash = new float[]{4.0f};
                        renderer.setSeriesStroke(s, (Stroke)new BasicStroke(1.0f, 0, 0, 1.0f, dash, 1.0f));
                    }
                    ++s;
                }
                plot.setRenderer(d, (XYItemRenderer)renderer);
                ++d;
            }
            XYTextAnnotation maxCountAnnot = null;
            XYTextAnnotation maxARTAnnot = null;
            double maxCountX = 0.0;
            double maxCountY = 0.0;
            double maxArtX = 0.0;
            double maxArtY = 0.0;
            int i2 = 0;
            while (i2 < this.maxValue[0].length) {
                if (maxCountY <= this.maxValue[0][i2]) {
                    maxCountY = this.maxValue[0][i2];
                    maxCountX = this.maxValueDomain[0][i2];
                }
                if (maxArtY <= this.maxValue[1][i2]) {
                    maxArtY = this.maxValue[1][i2];
                    maxArtX = this.maxValueDomain[1][i2];
                }
                ++i2;
            }
            double scalePrimary = 0.0 + prop.getRangeHigh(0.0, maxCountY);
            double scaleSecondary = 0.0 + prop.getRangeHigh(0.0, maxArtY);
            maxCountAnnot = new XYTextAnnotation(String.valueOf(Math.ceil(maxCountY)), maxCountX, maxCountY + 0.03 * scalePrimary);
            maxCountAnnot.setFont(new Font("Tahoma", 3, 12));
            maxARTAnnot = new XYTextAnnotation(String.valueOf(String.valueOf(Math.ceil(maxArtY))) + " ms", maxArtX, (maxArtY + 0.03 * scaleSecondary) * (scalePrimary / scaleSecondary));
            maxARTAnnot.setFont(new Font("Tahoma", 3, 12));
            plot.addAnnotation((XYAnnotation)maxCountAnnot);
            plot.addAnnotation((XYAnnotation)maxARTAnnot);
        }
    }
}

