/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.log.download;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class LogDownloader {
    public static final int TYPE_TXT = 0;
    public static final int TYPE_EXCEL = 1;
    protected Connection conn;
    protected String collectionID;
    protected String profileID;
    protected long from;
    protected long to;
    protected int referenceLimit;
    protected int requestLimit;
    protected int fileType;

    public LogDownloader(Connection conn, String collectionID, String profileID, long from, long to, int referenceLimit, int requestLimit) {
        this.conn = conn;
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.from = from;
        this.to = to;
        this.referenceLimit = referenceLimit;
        this.requestLimit = requestLimit;
        this.fileType = 0;
    }

    public LogDownloader(Connection conn, String collectionID, String profileID, long from, long to, int referenceLimit, int requestLimit, int fileType) {
        this.conn = conn;
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.from = from;
        this.to = to;
        this.referenceLimit = referenceLimit;
        this.requestLimit = requestLimit;
        this.fileType = fileType;
    }

    public abstract int writeLine(BufferedWriter var1, String var2) throws SQLException, IOException;

    public int write(String filePath, String delimiter, String encoding) throws IOException, SQLException {
        int count = 0;
        count = this.fileType == 0 ? this.writeTxt(filePath, delimiter, encoding) : this.writeExcel(filePath, delimiter);
        return count;
    }

    public int writeExcel(String filePath, String delimiter) throws IOException, SQLException {
        return 0;
    }

    public int writeTxt(String filePath, String delimiter, String encoding) throws IOException, SQLException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), encoding));
        try {
            int n = this.writeLine(writer, delimiter);
            return n;
        }
        finally {
            writer.close();
        }
    }
}

