/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.network;

import com.diquest.ir.client.network.ExternalClientWorker;
import com.diquest.ir.common.msg.ext.body.common.ErrorMessage;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ExternalClientPool {
    private static final int DEFAULT_POOL_WAIT_TIMEOUT = 5000;
    private static final int DEFAULT_MIN_POOL_SIZE = 1;
    private static final int DEFAULT_MAX_POOL_SIZE = 10;
    private int poolWaitTimeout = 5000;
    private int minPoolSize = 1;
    private int maxPoolSize = 10;
    private boolean propset = false;
    private static Map instance = new HashMap();
    private final String ip;
    private final int port;
    private Stack pool;
    private int poolSize;

    private ExternalClientPool(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.pool = new Stack();
        int i = 0;
        while (i < this.minPoolSize) {
            ExternalClientWorker worker = null;
            worker = new ExternalClientWorker(ip, port);
            this.pool.push(worker);
            ++this.poolSize;
            ++i;
        }
    }

    public final int getPoolWaitTimeout() {
        return this.poolWaitTimeout;
    }

    public synchronized boolean setProps(int poolWaitTimeout, int minPoolSize, int maxPoolSize) {
        if (!this.propset) {
            this.poolWaitTimeout = poolWaitTimeout;
            this.minPoolSize = minPoolSize;
            this.maxPoolSize = maxPoolSize;
            this.propset = true;
            return true;
        }
        return false;
    }

    public ExtResponse invoke(ExtRequest request) {
        ExternalClientWorker worker = this.getWorker();
        if (worker == null) {
            return null;
        }
        try {
            ExtResponse response;
            ExtResponse extResponse = response = worker.invoke(request);
            return extResponse;
        }
        catch (IOException e) {
            worker.close();
            System.out.println("Request failed [" + this.ip + ":" + this.port + "]");
            if (e instanceof ExternalClientWorker.IrIOException) {
                ExtResponse extResponse = new ExtResponse(((ExternalClientWorker.IrIOException)e).code, (Transmitable)new ErrorMessage(e.getMessage(), (Exception)e));
                return extResponse;
            }
            return null;
        }
        finally {
            this.releaseWorker(worker);
        }
    }

    public ExtResponse invoke(ExtRequest request, int timeout) {
        long waitStartTime = System.currentTimeMillis();
        ExternalClientWorker worker = this.getWorker();
        if (worker == null) {
            return null;
        }
        try {
            ExtResponse response;
            long waitEndTime = System.currentTimeMillis();
            request.setTimeout((long)timeout - (waitEndTime - waitStartTime));
            ExtResponse extResponse = response = worker.invoke(request, timeout);
            return extResponse;
        }
        catch (IOException e) {
            worker.close();
            System.out.println("Request failed [" + this.ip + ":" + this.port + "]");
            if (e instanceof ExternalClientWorker.IrIOException) {
                ExtResponse extResponse = new ExtResponse(((ExternalClientWorker.IrIOException)e).code, (Transmitable)new ErrorMessage(e.getMessage(), (Exception)e));
                return extResponse;
            }
            return null;
        }
        finally {
            this.releaseWorker(worker);
        }
    }

    private synchronized ExternalClientWorker getWorker() {
        ExternalClientWorker worker = null;
        boolean waited = false;
        while (worker == null) {
            if (this.pool.size() == 0) {
                this.propset = true;
                if (this.poolSize >= this.maxPoolSize) {
                    if (waited) break;
                    try {
                        this.wait(this.poolWaitTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    waited = false;
                } else {
                    worker = new ExternalClientWorker(this.ip, this.port);
                    ++this.poolSize;
                }
            } else {
                worker = (ExternalClientWorker)this.pool.pop();
            }
            try {
                if (worker == null || worker.available()) continue;
                worker.close();
                worker = null;
                --this.poolSize;
            }
            catch (IOException e) {
                if (worker != null) {
                    worker.close();
                }
                worker = null;
                --this.poolSize;
                e.printStackTrace();
            }
        }
        return worker;
    }

    private synchronized void releaseWorker(ExternalClientWorker worker) {
        this.pool.push(worker);
        this.notifyAll();
    }

    public static synchronized ExternalClientPool getInstance(String ip, int port) {
        String key = String.valueOf(ip) + ":" + port;
        ExternalClientPool pool = (ExternalClientPool)instance.get(key);
        if (pool == null) {
            pool = new ExternalClientPool(ip, port);
            instance.put(key, pool);
        }
        return pool;
    }

    public synchronized boolean isPropset() {
        return this.propset;
    }
}

