/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.network;

import com.diquest.ir.util.io.FastByteArrayInputStream;
import com.diquest.ir.util.io.FastByteArrayOutputStream;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.network.MessageLogic;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class ExternalClientWorker {
    private static final int ERRCODE_CONFAIL = -60003;
    private static final int ERRCODE_TIMEOUT = -60004;
    private static final int ERRCODE_NONTERMINATED_PROTOCOL = -60005;
    private static final int ERRCODE_INVALID_PROTOCOL = -60006;
    private static final int ERRCODE_EXCEPTION_CLOSE = -60011;
    private final String ip;
    private final int port;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private FastByteArrayOutputStream baos;
    private FastByteArrayInputStream bais;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.client.network.ExternalClientWorker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ExternalClientWorker(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.baos = new FastByteArrayOutputStream(256);
        this.bais = new FastByteArrayInputStream();
    }

    public void connect() throws IOException {
        try {
            this.socket = new Socket(this.ip, this.port);
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new IrIOException("Connection failed.", -60003);
        }
    }

    public void connect(int timeout) throws IOException {
        if (timeout < 0) {
            this.connect();
            return;
        }
        this.socket = new Socket();
        try {
            InetSocketAddress isa = new InetSocketAddress(InetAddress.getByName(this.ip), this.port);
            this.socket.connect(isa, timeout);
            this.socket.setSoTimeout(timeout);
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new IrIOException("Connection failed.", -60003);
        }
    }

    public void close() {
        if (this.socket == null) {
            return;
        }
        try {
            try {
                if (this.os != null) {
                    this.os.write(MessageLogic.CLOSE_PACKET);
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                this.socket = null;
                this.is = null;
                this.os = null;
            }
        }
        finally {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
            this.socket = null;
            this.is = null;
            this.os = null;
        }
    }

    public boolean isConnected() {
        return this.socket != null && !this.socket.isClosed() && this.socket.isConnected();
    }

    public boolean available() throws IOException {
        if (this.isConnected()) {
            if (this.socket.getInputStream().available() > 0) {
                this.socket.close();
                return false;
            }
            return true;
        }
        return true;
    }

    public ExtResponse invoke(ExtRequest request) throws IOException {
        return this.invoke(request, -1);
    }

    public ExtResponse invoke(ExtRequest request, int timeout) throws IOException {
        try {
            if (!this.isConnected()) {
                this.close();
                this.connect(timeout);
            }
            return this.transmit(request, timeout);
        }
        catch (ReconnectableException e) {
            this.close();
            this.connect(timeout);
            return this.transmit(request, timeout);
        }
    }

    private ExtResponse transmit(ExtRequest request, int timeout) throws IOException {
        try {
            if (!$assertionsDisabled && !this.socket.isConnected()) {
                throw new AssertionError((Object)"Not connected.");
            }
            MessageLogic.makePacket((FastByteArrayOutputStream)this.baos, (Transmitable)request);
            this.os.write(this.baos.array(), 0, this.baos.position());
            this.os.flush();
        }
        catch (IOException e) {
            throw new ReconnectableException("On sending: " + e.getMessage(), -60003);
        }
        long current = System.currentTimeMillis();
        int headerType = 0;
        try {
            headerType = MessageLogic.readPacket((FastByteArrayInputStream)this.bais, (InputStream)this.is);
        }
        catch (SocketTimeoutException e) {
            throw new IrIOException("Timed out", -60004);
        }
        catch (IOException e) {
            long threw = System.currentTimeMillis();
            if (timeout >= 0 && threw - current >= (long)timeout) {
                throw new IrIOException("Timed out: " + (threw - current) + "ms for " + timeout + "ms.", -60004);
            }
            throw new ReconnectableException("Cannot read data properly: " + e.getMessage(), -60005);
        }
        if (headerType == 3) {
            throw new ReconnectableException("A close packet is received.", -60011);
        }
        if (headerType != 1) {
            throw new IrIOException("A message header packet is not received.", -60006);
        }
        try {
            ExtResponse response = (ExtResponse)Transmitable.readFrom((InputStream)this.bais);
            return response;
        }
        catch (IOException e) {
            throw new IrIOException(e.toString(), -60006);
        }
    }

    public class IrIOException
    extends IOException {
        private static final long serialVersionUID = 3566377222255208005L;
        int code;

        public IrIOException(String s, int code) {
            super(s);
            this.code = code;
        }

        public String toString() {
            return String.valueOf(this.code) + ": " + super.toString();
        }
    }

    public class ReconnectableException
    extends IrIOException {
        private static final long serialVersionUID = -3432114956411813778L;

        public ReconnectableException(String s, int code) {
            super(s, code);
        }
    }
}

