/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.setting;

import com.diquest.ir.client.setting.ExportSummaryDocumentBuilder;
import com.diquest.ir.common.msg.ext.body.setting.ExportBasicSummary;
import com.diquest.ir.common.msg.ext.body.setting.ExportCollectionSummary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ExportSummaryCsvBuilder
extends ExportSummaryDocumentBuilder {
    private static final String ENCODING = "EUC-KR";
    private static final String W_SPACE = " ";
    private static final String DELIM = ",";
    private byte[] contents;

    public ExportSummaryCsvBuilder(String filename) {
        super(filename);
    }

    protected void writeBasic(ExportBasicSummary basic) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("\uac80\uc0c9 \uc5d4\uc9c4").append(NEWLINE);
        this.writeInfo(buf, "\uae30\ubcf8 \uc815\ubcf4", "ir_home", basic.getHome());
        this.writeInfo(buf, "\uae30\ubcf8 \uc815\ubcf4", "version", basic.getVersion());
        ExportBasicSummary.ExportRdbmsInfo rdbms = basic.getRdbmsInfo();
        this.writeInfo(buf, "DB \uc815\ubcf4", "table.prefix", rdbms.getPrefix());
        this.writeInfo(buf, "DB \uc815\ubcf4", "jdbc.username", rdbms.getUserId());
        this.writeInfo(buf, "DB \uc815\ubcf4", "jdbc.password", rdbms.getPassword());
        this.writeInfo(buf, "DB \uc815\ubcf4", "jdbc.url", rdbms.getUrl());
        ExportBasicSummary.ExportServerInfo[] servers = basic.getServerInfos();
        int i = 0;
        while (i < servers.length) {
            String serverName = servers[i].getName();
            this.writeInfo(buf, serverName, "ip", servers[i].getIp());
            this.writeInfo(buf, serverName, "port", servers[i].getPort());
            this.writeInfo(buf, serverName, "threadPool min size", servers[i].getThreadMin());
            this.writeInfo(buf, serverName, "threadPool max size", servers[i].getThreadMax());
            this.writeInfo(buf, serverName, "businessBuffer size", servers[i].getBusinessBufferSize());
            this.writeInfo(buf, serverName, "work cache size", servers[i].getWorkCacheSize());
            this.writeInfo(buf, serverName, "search cache size", servers[i].getSearchCacheSize());
            this.writeInfo(buf, serverName, "search cache result size", servers[i].getSearchCacheResultSize());
            ++i;
        }
        ExportBasicSummary.ExportJdbcInfo[] jdbcInfo = basic.getJdbcInfos();
        if (jdbcInfo != null) {
            buf.append(NEWLINE).append("\uae30\ubcf8 \uc815\ubcf4").append(NEWLINE);
            int i2 = 0;
            while (i2 < jdbcInfo.length) {
                String jdbcName = jdbcInfo[i2].getId();
                this.writeInfo(buf, jdbcName, "\uc0c1\uc138\uc124\uba85", jdbcInfo[i2].getDesc());
                this.writeInfo(buf, jdbcName, "JDBC \ub4dc\ub77c\uc774\ubc84", jdbcInfo[i2].getDriver());
                this.writeInfo(buf, jdbcName, "JDBC URL", jdbcInfo[i2].getUrl());
                this.writeInfo(buf, jdbcName, "\uc811\uc18d \uc544\uc774\ub514", jdbcInfo[i2].getUserId());
                this.writeInfo(buf, jdbcName, "\uc811\uc18d \ube44\ubc00\ubc88\ud638", jdbcInfo[i2].getPassword());
                ++i2;
            }
        }
        this.contents = buf.toString().getBytes(ENCODING);
    }

    protected void writeCollectionSetting(ExportCollectionSummary[] infos) throws UnsupportedEncodingException {
        if (infos == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(1024);
        int i = 0;
        while (i < infos.length) {
            ExportCollectionSummary.ExportCollectingSettingInfo[] settingInfo;
            buf.append(NEWLINE);
            buf.append(NEWLINE).append("Collection").append(NEWLINE);
            this.writeInfo(buf, "Collection \uc815\ubcf4", "Collection", infos[i].getCollectionName());
            this.writeInfo(buf, "Collection \uc815\ubcf4", "\uc0c1\uc138\uc124\uba85", infos[i].getCollectionDesc());
            this.writeInfo(buf, "Collection \uc815\ubcf4", "\uc800\uc7a5\uc11c\ubc84", infos[i].getCollectionServer());
            this.writeInfo(buf, "Collection \uc815\ubcf4", "\uc218\uc9d1\ubaa8\ub4c8", infos[i].getCollectModule());
            this.writeInfo(buf, "Collection \uc815\ubcf4", "Mirroring \uc5ec\ubd80", infos[i].getMirroring());
            buf.append(NEWLINE).append("Field").append(NEWLINE);
            ExportCollectionSummary.ExportCollectionFieldInfo[] fieldsInfo = infos[i].getFieldInfos();
            this.writeFieldInfo(buf, "\ud544\ub4dc \uc774\ub984", "\ud544\ub4dc \uc124\uba85", "\ud544\ub4dc \ud0c0\uc785", "ID \ud544\ub4dc", "\uc0c9\uc778", "\uc815\ub82c", "\ud544\ud130", "\uadf8\ub8f9");
            if (fieldsInfo != null) {
                int j = 0;
                while (j < fieldsInfo.length) {
                    this.writeFieldInfo(buf, fieldsInfo[j].getFieldName(), fieldsInfo[j].getDesc(), fieldsInfo[j].getType(), fieldsInfo[j].getIdField(), fieldsInfo[j].getIndexField(), fieldsInfo[j].getSortField(), fieldsInfo[j].getFilterField(), fieldsInfo[j].getGroupField());
                    ++j;
                }
            }
            if ((settingInfo = infos[i].getSettingInfos()) != null) {
                buf.append(NEWLINE);
                buf.append("\uc218\uc9d1 \uc124\uc815").append(NEWLINE);
                this.writeCollectingSettingInfo(buf, "DB \uc218\uc9d1 \uc774\ub984", "\uc0c1\uc138\uc124\uba85", "Fetch", "Bulk", "\ucd9c\ub825\ud30c\uc77c \uc778\ucf54\ub529", "\uc218\uc9d1 Extension", "\ucca8\ubd80\ud30c\uc77c \ud544\ud130");
                int j = 0;
                while (j < settingInfo.length) {
                    this.writeCollectingSettingInfo(buf, settingInfo[j].getId(), settingInfo[j].getDesc(), settingInfo[j].getFetchSize(), settingInfo[j].getBulkFactor(), settingInfo[j].getEncoding(), settingInfo[j].getExtensionName(), settingInfo[j].getAttachedField());
                    ++j;
                }
            }
            ++i;
        }
        byte[] collectionBytes = buf.toString().getBytes(ENCODING);
        if (collectionBytes == null) {
            return;
        }
        byte[] newBytes = new byte[this.contents.length + collectionBytes.length];
        System.arraycopy(this.contents, 0, newBytes, 0, this.contents.length);
        System.arraycopy(collectionBytes, 0, newBytes, this.contents.length, collectionBytes.length);
        this.contents = newBytes;
    }

    public byte[] getFileContent() {
        return this.contents;
    }

    public File getFile() throws IOException {
        File document = new File(this.filename);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(document);
            fos.write(this.contents);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return document;
    }

    private void writeInfo(StringBuffer buf, String mainTag, String info) {
        buf.append(this.converDelim(mainTag)).append(W_SPACE).append(DELIM).append(this.converDelim(info)).append(W_SPACE).append(NEWLINE);
    }

    private void writeInfo(StringBuffer buf, String mainTag, String middleTag, String info) {
        buf.append(this.converDelim(mainTag)).append(W_SPACE).append(DELIM).append(this.converDelim(middleTag)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(info)).append(W_SPACE).append(NEWLINE);
    }

    private void writeFieldInfo(StringBuffer buf, String name, String desc, String type, String id, String index, String sort, String filter, String group) {
        buf.append(this.converDelim(name)).append(W_SPACE).append(DELIM).append(this.converDelim(desc)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(type)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(id)).append(W_SPACE).append(DELIM).append(this.converDelim(index)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(sort)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(filter)).append(W_SPACE).append(DELIM).append(this.converDelim(group)).append(W_SPACE).append(NEWLINE);
    }

    private void writeCollectingSettingInfo(StringBuffer buf, String name, String desc, String fetch, String bulk, String encoding, String extension, String attached) {
        buf.append(this.converDelim(name)).append(W_SPACE).append(DELIM).append(this.converDelim(desc)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(fetch)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(bulk)).append(W_SPACE).append(DELIM).append(this.converDelim(encoding)).append(W_SPACE).append(DELIM);
        buf.append(this.converDelim(extension)).append(W_SPACE).append(DELIM).append(this.converDelim(attached)).append(W_SPACE).append(NEWLINE);
    }

    private String converDelim(String input) {
        return input.replaceAll(DELIM, "&comm;");
    }

    protected void close() {
    }

    public String getString() {
        String str = "";
        try {
            str = new String(this.contents, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }
}

