/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.setting.command;

import com.diquest.ir.client.network.ExternalClient;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.SettingT;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.TransmitableUtil;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.StringT;
import java.io.IOException;
import java.net.UnknownHostException;

public class CommandSetting
extends ExternalClient {
    private String adminip;
    private int adminPort;

    public CommandSetting(String ip, int port) throws UnknownHostException, IRException {
        super(ip, port);
        this.adminip = ip;
        this.adminPort = port;
    }

    public int requestMock(String serverName, String[] settingNames) throws IOException {
        ArrayT settingListArray = new ArrayT((Transmitable[])StringT.convert((String[])settingNames));
        ExtRequest request = new ExtRequest("com.diquest.ir.framework.setting.msg.ExtMessageSettingResponse", (Transmitable)settingListArray);
        ExtResponse response = null;
        response = this.invoke(request);
        return response.getErrorCode();
    }

    public SettingT[] requestSetting(String serverName, String[] settingNames) throws IRException {
        return this.requestSetting(settingNames);
    }

    public SettingT[] requestSetting(String[] settingNames) throws IRException {
        ArrayT settingListArray = new ArrayT((Transmitable[])StringT.convert((String[])settingNames));
        ExtRequest request = new ExtRequest("com.diquest.ir.framework.setting.msg.ExtMessageSettingResponse", (Transmitable)settingListArray);
        ExtResponse response = null;
        boolean responseSuccess = true;
        try {
            response = this.invoke(request);
        }
        catch (UnknownHostException e) {
            throw new IRException(2, "Cannot find host [IP : " + this.adminip + "][port : " + this.adminPort + "].", (Throwable)e);
        }
        catch (IOException e) {
            responseSuccess = false;
        }
        if (response == null || response.getErrorCode() < 0) {
            responseSuccess = false;
        }
        if (!responseSuccess) {
            System.out.println("RETRY request setting to AdminServer.");
            try {
                response = this.invoke(request);
            }
            catch (UnknownHostException e) {
                throw new IRException(2, "Cannot find host [IP : " + this.adminip + "][port : " + this.adminPort + "].", (Throwable)e);
            }
            catch (IOException e) {
                throw new IRException(2, "Cannot request for setting [IP : " + this.adminip + "]  [port : " + this.adminPort + "]", (Throwable)e);
            }
            if (response == null || response.getErrorCode() < 0) {
                throw new IRException(2, "Setting request/receive failed from AdminServer.");
            }
        }
        ArrayT resultData = (ArrayT)response.getData();
        return (SettingT[])TransmitableUtil.copy((Transmitable[])resultData.value, (Transmitable[])new SettingT[resultData.value.length]);
    }
}

