/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class ChartProperties
extends Properties {
    public static final String CHART_TITLE = "CHART_TITLE";
    public static final int DOMAIN_INDEX = 0;
    public static final String DOMAIN_LABEL = "DOMAIN_LABEL";
    public static final int RANGE_INDEX = 1;
    public static final long serialVersionUID = 4563329788630384992L;
    public static final String TIME_TICK = "TIME_TICK";
    String[] axisLabels;
    Object[][][][] plotValues;
    String[][] seriesLabels;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public final String[] getAxisLabels() {
        return this.axisLabels;
    }

    public final String getChartTitle() {
        return super.getProperty(CHART_TITLE);
    }

    public final Date[] getDomain(int dataset, int series) {
        return (Date[])this.plotValues[dataset][series][0];
    }

    public final String getDomainLabel() {
        return super.getProperty(DOMAIN_LABEL);
    }

    public SimpleDateFormat getFormat(Class timePeriodClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Millisecond");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(timePeriodClass)) {
            return new SimpleDateFormat("HH:mm ss.S");
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.jfree.data.time.Second");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(timePeriodClass)) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(timePeriodClass)) {
            return new SimpleDateFormat("MM/dd HH:mm");
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.jfree.data.time.Hour");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.isAssignableFrom(timePeriodClass)) {
            return new SimpleDateFormat("MM/dd HH");
        }
        return new SimpleDateFormat("yy/MM/dd");
    }

    public final int getNumDataset() {
        return this.plotValues.length;
    }

    public final int getNumSeries(int dataset) {
        return this.plotValues[dataset].length;
    }

    public final Double[] getRange(int dataset, int series) {
        return (Double[])this.plotValues[dataset][series][1];
    }

    public double getRangeHigh(double min, double max) {
        return max + (max - this.getRangeLow(min, max)) * 0.15;
    }

    public double getRangeLow(double min, double max) {
        if (min >= 0.0) {
            return 0.0;
        }
        return min - (max - min) * 0.15;
    }

    public final String getSeriesLabel(int dataset, int series) {
        return this.seriesLabels[dataset][series];
    }

    public final long getTimeTick(long dflt) {
        return Long.parseLong(super.getProperty(TIME_TICK, String.valueOf(dflt)));
    }

    public final void setAxisLabels(String axisLabel) {
        this.setAxisLabels(new String[]{axisLabel});
    }

    public final void setAxisLabels(String[] axisLabels) {
        this.axisLabels = axisLabels;
    }

    public final void setChartTitle(String title) {
        super.setProperty(CHART_TITLE, title);
    }

    public final void setDomainLabel(String label) {
        super.setProperty(DOMAIN_LABEL, label);
    }

    public final void setPlotValues(Object[][] plotValues) {
        this.setPlotValues(new Object[][][]{plotValues});
    }

    public final void setPlotValues(Object[][][] plotValues) {
        this.setPlotValues(new Object[][][][]{plotValues});
    }

    public final void setPlotValues(Object[][][][] plotValues) {
        this.plotValues = plotValues;
    }

    public final void setSeriesLabels(String seriesLabel) {
        this.setSeriesLabels(new String[]{seriesLabel});
    }

    public final void setSeriesLabels(String[] seriesLabels) {
        this.setSeriesLabels(new String[][]{seriesLabels});
    }

    public final void setSeriesLabels(String[][] seriesLabels) {
        this.seriesLabels = seriesLabels;
    }

    public final void setTimeTick(long value) {
        super.setProperty(TIME_TICK, String.valueOf(value));
    }
}

