/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.ir.common.exception.ContextException;
import java.io.PrintStream;

public class EarthException
extends Exception {
    private static final long serialVersionUID = 7377715131454856624L;
    private final String service;
    private final String module;

    public EarthException(String service, String module, String message) {
        super(message);
        this.service = service;
        this.module = module;
    }

    public EarthException(String service, String module, String message, Throwable cause) {
        super(message, cause);
        this.service = service;
        this.module = module;
    }

    public EarthException(ContextException ce) {
        super(ce.getMessage(), ce.getCause());
        this.service = ce.getService();
        this.module = ce.getModule();
    }

    public String getBusinessMessage() {
        this.getLocalizedMessage();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            EarthException c = this;
            while (c != null) {
                s.println("[" + c.service + "] " + c.module + " : " + c.getMessage());
                Throwable cause = c.getCause();
                if (cause == null) break;
                if (cause instanceof EarthException) {
                    c = (EarthException)cause;
                    continue;
                }
                cause.printStackTrace(s);
                break;
            }
        }
    }
}

