/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.ir.client.util.ChartProperty;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.TextAnchor;

public class EasyBar {
    JFreeChart chart;
    ChartProperty property;

    public EasyBar(ChartProperty property) {
        this.property = property;
        this.chart = this.createChart(this.createDataset());
        this.setProperty(this.chart);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private CategoryDataset createDataset() {
        return DatasetUtilities.createCategoryDataset((Comparable[])this.property.getSeriesLabels(), (Comparable[])this.property.getGroupLabels(), (double[][])this.property.getValues());
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        boolean showLegend = false;
        if (this.property.getLegendShow()) {
            showLegend = true;
        }
        PlotOrientation orientType = PlotOrientation.VERTICAL;
        if ("horizontal".equals(this.property.getOrientType())) {
            orientType = PlotOrientation.HORIZONTAL;
        }
        if (this.property.is3D()) {
            return ChartFactory.createBarChart3D((String)this.property.getTitle(), (String)this.property.getXAxisText(), (String)this.property.getYAxisText(), (CategoryDataset)dataset, (PlotOrientation)orientType, (boolean)showLegend, (boolean)false, (boolean)false);
        }
        return ChartFactory.createBarChart((String)this.property.getTitle(), (String)this.property.getXAxisText(), (String)this.property.getYAxisText(), (CategoryDataset)dataset, (PlotOrientation)orientType, (boolean)showLegend, (boolean)false, (boolean)false);
    }

    private void setProperty(JFreeChart chart) {
        if (this.property.getAppBgColor() != null) {
            chart.setBackgroundPaint((Paint)this.getColor(this.property.getAppBgColor()));
        }
        CategoryPlot cplot = chart.getCategoryPlot();
        if (this.property.getChartBgColor() != null) {
            cplot.setBackgroundPaint((Paint)this.getColor(this.property.getChartBgColor()));
        }
        if (this.property.getBarBottomColors() != null) {
            String[] colors = this.property.getBarBottomColors();
            String[] colors2 = this.property.getBarTopColors();
            int i = 0;
            while (i < colors.length) {
                GradientPaint gradientpaint = new GradientPaint(0.0f, 0.0f, this.getColor(colors2[i]), 0.0f, 0.0f, this.getColor(colors[i]));
                cplot.getRenderer().setSeriesPaint(i, (Paint)gradientpaint);
                ++i;
            }
        }
        if (this.property.getRangeGridLine() != null && "none".equals(this.property.getRangeGridLine())) {
            cplot.setRangeGridlinesVisible(false);
        } else {
            cplot.setRangeGridlinesVisible(true);
        }
        if (this.property.getRangeGridLineColor() != null) {
            cplot.setRangeGridlinePaint((Paint)this.getColor(this.property.getRangeGridLineColor()));
        }
        if (this.property.getDomainGridLine() != null && "show".equals(this.property.getDomainGridLine())) {
            cplot.setDomainGridlinesVisible(true);
        } else {
            cplot.setDomainGridlinesVisible(false);
        }
        if (this.property.getDomainGridLineColor() != null) {
            cplot.setDomainGridlinePaint((Paint)this.getColor(this.property.getDomainGridLineColor()));
        }
        if (this.property.isShowItemLabels()) {
            BarRenderer brenderer = (BarRenderer)cplot.getRenderer();
            brenderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            brenderer.setItemLabelFont(new Font("SansSerif", 0, 10));
            brenderer.setItemLabelsVisible(true);
            ItemLabelPosition itemlabelposition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
            brenderer.setPositiveItemLabelPosition(itemlabelposition);
            ItemLabelPosition itemlabelposition1 = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
            brenderer.setPositiveItemLabelPositionFallback(itemlabelposition1);
        }
        CategoryAxis caxis = cplot.getDomainAxis();
        caxis.setTickLabelFont(new Font("gulim", 0, 13));
    }

    private Color getColor(String hexValue) {
        return new Color(Integer.valueOf(hexValue, 16));
    }
}

