/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.ir.client.util.ChartProperty;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class EasyPie {
    JFreeChart chart;
    ChartProperty property;

    public EasyPie(ChartProperty property) {
        this.property = property;
        this.chart = this.createChart(this.createDataset());
        this.setProperty(this.chart);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private PieDataset createDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        String[] label = this.property.getGroupLabels();
        double[] values = this.property.getValues()[0];
        int i = 0;
        while (i < values.length) {
            dataset.setValue((Comparable)((Object)label[i]), values[i]);
            ++i;
        }
        return dataset;
    }

    private JFreeChart createChart(PieDataset dataset) {
        boolean showLegend = false;
        if (this.property.getLegendShow()) {
            showLegend = true;
        }
        if (this.property.is3D()) {
            return ChartFactory.createPieChart3D((String)this.property.getTitle(), (PieDataset)dataset, (boolean)showLegend, (boolean)false, (boolean)false);
        }
        return ChartFactory.createPieChart((String)this.property.getTitle(), (PieDataset)dataset, (boolean)showLegend, (boolean)false, (boolean)false);
    }

    private void setProperty(JFreeChart chart) {
        if (this.property.getAppBgColor() != null) {
            chart.setBackgroundPaint((Paint)this.getColor(this.property.getAppBgColor()));
        }
        PiePlot pplot = (PiePlot)chart.getPlot();
        if (this.property.getChartBgColor() != null) {
            pplot.setBackgroundPaint((Paint)this.getColor(this.property.getChartBgColor()));
        }
        pplot.setLabelFont(new Font("\uad74\ub9bc", 0, 12));
        pplot.setCircular(true);
        if (this.property.getBarColors() != null) {
            String[] colors = this.property.getBarColors();
            int i = 0;
            while (i < colors.length) {
                pplot.setSectionPaint(i, (Paint)this.getColor(colors[i]));
                ++i;
            }
        }
    }

    private Color getColor(String hexValue) {
        return new Color(Integer.valueOf(hexValue, 16));
    }
}

