/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.ir.client.util.ChartProperties;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class EasyTimeSeries {
    protected XYDataset[] datasets;
    protected double[][] minValue = null;
    protected double[][] maxValue = null;
    protected double[][] minValueDomain = null;
    protected double[][] maxValueDomain = null;
    protected JFreeChart chart;
    protected Class timeClazz;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.client.util.EasyTimeSeries");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected static Class getTimePeriodClass(long millis) {
        if (!$assertionsDisabled && millis <= 0L) {
            throw new AssertionError();
        }
        long SEC = 1000L;
        long MIN = 60L * SEC;
        long HOUR = 60L * MIN;
        long DAY = 24L * HOUR;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Millisecond");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> timePeriodClass = clazz;
        if (millis % MIN != 0L) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.jfree.data.time.Second");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            timePeriodClass = clazz2;
        } else if (millis % HOUR != 0L) {
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("org.jfree.data.time.Minute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            timePeriodClass = clazz3;
        } else if (millis % DAY != 0L) {
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("org.jfree.data.time.Hour");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            timePeriodClass = clazz4;
        } else {
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("org.jfree.data.time.Day");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            timePeriodClass = clazz5;
        }
        return timePeriodClass;
    }

    private static double mapping(double xsize, double ysize, double yposition) {
        return xsize / ysize * yposition;
    }

    public EasyTimeSeries(ChartProperties prop) {
        this.datasets = this.createDataset(prop);
        if (!($assertionsDisabled || this.datasets != null && this.datasets.length >= 1)) {
            throw new AssertionError();
        }
        this.chart = ChartFactory.createTimeSeriesChart((String)prop.getChartTitle(), (String)prop.getDomainLabel(), (String)"", (XYDataset)this.datasets[0], (boolean)true, (boolean)true, (boolean)false);
        this.fillChartComponent(prop);
        this.decorateChart(prop);
    }

    protected void decorateChart(ChartProperties prop) {
        XYPlot plot = this.chart.getXYPlot();
        int d = 0;
        while (d < prop.getNumDataset()) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setShapesVisible(true);
            renderer.setShapesFilled(true);
            plot.setRenderer(d, (XYItemRenderer)renderer);
            ++d;
        }
    }

    private void checkMinMax(int d, int s, Date x, double y) {
        if (this.minValue[d][s] > y) {
            this.minValueDomain[d][s] = x.getTime();
            this.minValue[d][s] = y;
        }
        if (this.maxValue[d][s] < y) {
            this.maxValueDomain[d][s] = x.getTime();
            this.maxValue[d][s] = y;
        }
    }

    protected XYDataset[] createDataset(ChartProperties prop) {
        TimeZone timeZone = TimeZone.getDefault();
        this.timeClazz = EasyTimeSeries.getTimePeriodClass(prop.getTimeTick(60000L));
        int numDataset = prop.getNumDataset();
        TimeSeriesCollection[] datasets = new TimeSeriesCollection[numDataset];
        this.initMinMax(numDataset);
        int d = 0;
        while (d < numDataset) {
            datasets[d] = new TimeSeriesCollection(timeZone);
            int numSeries = prop.getNumSeries(d);
            this.initMinMax(d, numSeries);
            int s = 0;
            while (s < numSeries) {
                TimeSeries series = new TimeSeries(prop.getSeriesLabel(d, s), this.timeClazz);
                Date[] domains = prop.getDomain(d, s);
                Double[] values = prop.getRange(d, s);
                if (!$assertionsDisabled && domains.length != values.length) {
                    throw new AssertionError();
                }
                int numEntry = domains.length;
                int e = 0;
                while (e < numEntry) {
                    Date date = domains[e];
                    double value = values[e];
                    this.checkMinMax(d, s, date, value);
                    series.add(RegularTimePeriod.createInstance((Class)this.timeClazz, (Date)date, (TimeZone)timeZone), value);
                    ++e;
                }
                datasets[d].addSeries(series);
                ++s;
            }
            ++d;
        }
        return datasets;
    }

    protected void fillChartComponent(ChartProperties prop) {
        XYPlot plot = this.chart.getXYPlot();
        String[] axisLabels = prop.getAxisLabels();
        if (!($assertionsDisabled || axisLabels.length > 0 && axisLabels.length <= this.datasets.length)) {
            throw new AssertionError();
        }
        DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
        domainAxis.setDateFormatOverride((DateFormat)prop.getFormat(this.timeClazz));
        int i = 0;
        while (i < axisLabels.length) {
            NumberAxis axis = new NumberAxis(axisLabels[i]);
            double datasetMin = this.min(this.minValue[i]);
            double datasetMax = this.max(this.maxValue[i]);
            axis.setRange(prop.getRangeLow(datasetMin, datasetMax), prop.getRangeHigh(datasetMin, datasetMax));
            plot.setRangeAxis(i, (ValueAxis)axis);
            ++i;
        }
        int d = 0;
        while (d < this.datasets.length) {
            plot.setDataset(d, this.datasets[d]);
            plot.mapDatasetToRangeAxis(d, d < axisLabels.length ? d : 0);
            ++d;
        }
    }

    private double max(double[] arr) {
        if (arr.length == 0) {
            return Double.NaN;
        }
        double max = arr[0];
        int i = 1;
        while (i < arr.length) {
            if (max < arr[i]) {
                max = arr[i];
            }
            ++i;
        }
        return max;
    }

    private double min(double[] arr) {
        if (arr.length == 0) {
            return Double.NaN;
        }
        double min = arr[0];
        int i = 1;
        while (i < arr.length) {
            if (min > arr[i]) {
                min = arr[i];
            }
            ++i;
        }
        return min;
    }

    private void initMinMax(int numDataset) {
        this.minValue = new double[numDataset][];
        this.maxValue = new double[numDataset][];
        this.minValueDomain = new double[numDataset][];
        this.maxValueDomain = new double[numDataset][];
    }

    private void initMinMax(int dataset, int numSeries) {
        this.minValue[dataset] = new double[numSeries];
        this.maxValue[dataset] = new double[numSeries];
        this.minValueDomain[dataset] = new double[numSeries];
        this.maxValueDomain[dataset] = new double[numSeries];
        Arrays.fill(this.minValueDomain[dataset], Double.POSITIVE_INFINITY);
        Arrays.fill(this.minValue[dataset], Double.POSITIVE_INFINITY);
        Arrays.fill(this.maxValueDomain[dataset], Double.NEGATIVE_INFINITY);
        Arrays.fill(this.maxValue[dataset], Double.NEGATIVE_INFINITY);
    }

    public JFreeChart getChart() {
        return this.chart;
    }
}

