/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.commons.type.StringUtil;
import java.util.HashMap;

public class ExtractorTypes {
    private static final String UNKNOWN = "UNKNOWN";
    private static final String EMPTY = "";
    private static HashMap extractorMap = new HashMap();
    private static HashMap optionMap = new HashMap();

    static {
        extractorMap.put("WHITE_SPACE", "\uc5b4\uc808\ubd84\uc11d");
        extractorMap.put("FIELD", "FIELD");
        extractorMap.put("KOREAN", "\ud55c\uad6d\uc5b4 \ud615\ud0dc\uc18c \ubd84\uc11d");
        extractorMap.put("BIGRAM", "BIGRAM");
        extractorMap.put("TRIGRAM", "TRIGRAM");
        extractorMap.put("QUADGRAM", "QUADGRAM");
        extractorMap.put("KOREAN_EXTEND", "\ud655\uc7a5 \ud55c\uad6d\uc5b4 \ud615\ud0dc\uc18c \ubd84\uc11d");
        extractorMap.put("KOREAN_NOUN", "\ud55c\uad6d\uc5b4 \uba85\uc0ac \ubd84\uc11d");
        extractorMap.put("ENGLISH", "\uc601\uc5b4 \ud615\ud0dc\uc18c \ubd84\uc11d");
        extractorMap.put("JAPANESE", "\uc77c\ubcf8\uc5b4 \ud615\ud0dc\uc18c \ubd84\uc11d");
        extractorMap.put("CHINESE", "\uc911\uad6d\uc5b4 \ud615\ud0dc\uc18c \ubd84\uc11d");
        extractorMap.put("DELIMITER", "\uad6c\ubd84\uc790 \uc0c9\uc778");
        extractorMap.put("UNIGRAM", "UNIGRAM");
        extractorMap.put("STEM", "(\uc601\ubb38 STEMMIMG)");
        extractorMap.put("ENG", "(\uc601\ubb38 BIGRAM)");
        extractorMap.put("MODEL", "(\ubaa8\ub378\uba85\ucd94\ucd9c)");
        extractorMap.put("TRIM", "(TRIM)");
        extractorMap.put("TRIMENG", "(\uc601\ubb38 BIGRAM TRIM)");
    }

    public static String getExtractor(String extractor) {
        if (StringUtil.isEmpty((String)extractor)) {
            return EMPTY;
        }
        String upper = extractor.toUpperCase();
        String value = (String)extractorMap.get(upper);
        if (value == null) {
            return UNKNOWN;
        }
        return value;
    }

    public static String getOption(String option) {
        if (StringUtil.isEmpty((String)option)) {
            return EMPTY;
        }
        String upper = option.toUpperCase();
        String value = (String)optionMap.get(upper);
        if (value == null) {
            return UNKNOWN;
        }
        return value;
    }

    public static void main(String[] args) {
        System.out.println(ExtractorTypes.getExtractor("Korean"));
        System.out.println(ExtractorTypes.getOption("ste"));
    }
}

