/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.ir.util.common.StringLineReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class FileUploadRequestHandler
implements StringLineReader {
    private static final int internalBufferSize = 8192;
    private byte[] buf = new byte[8192];
    private InputStream is;
    private String encoding;
    private String boundary;
    private String fileName;
    private String fileLine;
    private String fileEncoding;
    private BufferedReader reader;
    private BufferedReader fileBufferedReader;
    private String tempFile;
    private HashMap formData;

    public FileUploadRequestHandler(HttpServletRequest request, String encoding, String tempFile) throws IOException {
        if (encoding == null) {
            this.encoding = request.getCharacterEncoding();
        }
        this.tempFile = tempFile;
        boolean deleted = new File(this.tempFile).delete();
        if (!deleted) {
            System.out.println("WARN : file[" + this.tempFile + "] is not deleted");
        }
        this.formData = new HashMap();
        ServletInputStream servLetIS = request.getInputStream();
        this.parseRequest(request, servLetIS);
        this.reader = this.fileEncoding != null ? new BufferedReader(new InputStreamReader(this.is, this.fileEncoding)) : new BufferedReader(new InputStreamReader(this.is));
        this.fileLine = this.reader.readLine();
        while (this.fileLine.trim().length() == 0) {
            this.fileLine = this.reader.readLine();
        }
    }

    private InputStream writeAndGet(InputStream requestIS, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(requestIS, encoding);
        this.fileBufferedReader = new BufferedReader(reader);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), encoding));
        String line = this.fileBufferedReader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                if (line.startsWith(this.boundary)) break;
                bw.write(line);
                bw.write(10);
            }
            line = this.fileBufferedReader.readLine();
        }
        this.fileBufferedReader.close();
        bw.close();
        FileInputStream fis = new FileInputStream(this.tempFile);
        return fis;
    }

    private void parseRequest(HttpServletRequest request, ServletInputStream servLetIS) throws IOException {
        String type = null;
        String type1 = request.getHeader("Content-Type");
        String type2 = request.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        boolean prepared = false;
        this.boundary = this.extractBoundary(type);
        if (this.boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        while (true) {
            int end;
            int start;
            String line = null;
            if (!prepared) {
                line = this.readNextLine(servLetIS);
            }
            if (line == null) break;
            if (!line.startsWith(this.boundary)) continue;
            do {
                if ((line = this.readNextLine(servLetIS)) != null) continue;
                throw new IOException("Corrupt form data: premature ending");
            } while (!line.toLowerCase().startsWith("content-disposition:"));
            int fNameIndex = line.toLowerCase().indexOf("filename=\"");
            if (fNameIndex > 0) {
                start = line.toLowerCase().lastIndexOf("filename=\"");
                String fname = line.substring(start + 10, end = line.indexOf("\"", start + 10));
                int slash = Math.max(fname.lastIndexOf(47), fname.lastIndexOf(92));
                if (slash > -1) {
                    fname = fname.substring(slash + 1);
                }
                this.fileName = fname;
                this.fileEncoding = this.getEncoding(this.fileName);
                if (this.fileEncoding == null) {
                    String fileSuffix = this.fileName.substring(this.fileName.lastIndexOf(".") + 1);
                    throw new IOException(String.valueOf(fileSuffix) + " is not supported encoding type. Check please.");
                }
                do {
                    if ((line = this.readNextLine(servLetIS)) != null) continue;
                    throw new IOException("Corrupt form data: premature ending");
                } while (!line.toLowerCase().startsWith("content-type:"));
                this.is = this.writeAndGet((InputStream)servLetIS, this.fileEncoding);
                prepared = true;
                continue;
            }
            start = line.toLowerCase().lastIndexOf("name=\"");
            end = line.indexOf("\"", start + 6);
            String key = line.substring(start + 6, end);
            do {
                if ((line = this.readNextLine(servLetIS)) != null) continue;
                throw new IOException("Corrupt form data: premature ending");
            } while (line.trim().length() <= 0);
            String value = line.trim();
            this.formData.put(key, value);
        }
    }

    private final String getEncoding(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        String encoding = fileName.substring(idx + 1).trim();
        if (encoding.length() == 0 || !Charset.isSupported(encoding)) {
            return null;
        }
        return encoding;
    }

    public String readLine() throws IOException {
        if (this.fileLine == null) {
            return null;
        }
        try {
            String string = this.fileLine;
            return string;
        }
        finally {
            this.fileLine = this.reader.readLine();
            if (this.fileLine != null && this.fileLine.startsWith(this.boundary)) {
                this.fileLine = null;
            }
        }
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private String readNextLine(ServletInputStream servLetIS) throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = servLetIS.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, this.encoding));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len >= 2 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else if (len >= 1 && sbuf.charAt(len - 1) == '\n') {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    public void close() throws IOException {
        this.reader.close();
        if (this.fileBufferedReader != null) {
            this.fileBufferedReader.close();
        }
        this.is.close();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public String getParameter(String key) {
        return (String)this.formData.get(key);
    }

    public boolean getBoolean(String sName, boolean defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        boolean retr = (value = value.trim().toUpperCase()).equals("TRUE") || value.equals("ON") || value.equals("1") ? true : (value.equals("FALSE") || value.equals("OFF") || value.equals("0") ? false : defaultValue);
        return retr;
    }

    public int getInteger(String sName, int defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String sName, long defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public float getFloat(String sName, float defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public double getDouble(String sName, double defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public char getCharacter(String sName, char defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return value.charAt(0);
    }

    public char getCharacter(String sName, int position, char defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return value.charAt(position);
    }

    public byte getByte(String sName, byte defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException ne) {
            return defaultValue;
        }
    }
}

