/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.ir.common.msg.protocol.query.WhereSet;
import java.util.ArrayList;
import java.util.Arrays;

public class QueryParser {
    private static final char BRACE_OPEN = '(';
    private static final char BRACE_CLOSE = ')';
    private static final char AND = '&';
    private static final char OR = '|';
    private static final char NOT = '~';
    private char[] source;
    private char[] indexID;
    private int currentPos = 2;
    private byte operation;
    private int weight;

    public QueryParser(String indexID, byte operation, String str, int weight) {
        this.source = this.validateStr(str);
        this.indexID = indexID.toCharArray();
        this.operation = operation;
        this.weight = weight;
    }

    public WhereSet[] getWhereSet() {
        ArrayList<WhereSet> wheres = new ArrayList<WhereSet>();
        int[] cp = this.getCutPos();
        int prevCp = 0;
        int i = 0;
        while (i < cp.length && cp[i] >= 0) {
            char c;
            if (cp[i] - prevCp - 1 > 0) {
                char[] kw = new char[cp[i] - prevCp - 2];
                System.arraycopy(this.source, prevCp + 1, kw, 0, cp[i] - prevCp - 2);
                wheres.add(new WhereSet(this.indexID, this.operation, (char[][])new char[][]{kw}, new int[]{this.weight}));
            }
            if ((c = this.source[cp[i]]) == '(') {
                wheres.add(new WhereSet(9));
            } else if (c == ')') {
                wheres.add(new WhereSet(10));
            } else if (c == '&') {
                wheres.add(new WhereSet(5));
            } else if (c == '|') {
                wheres.add(new WhereSet(6));
            } else if (c == '~') {
                wheres.add(new WhereSet(7));
            }
            prevCp = cp[i] + 1;
            ++i;
        }
        if (prevCp + 1 < this.source.length) {
            char[] kw = new char[this.source.length - prevCp - 2];
            System.arraycopy(this.source, prevCp + 1, kw, 0, this.source.length - prevCp - 2);
            wheres.add(new WhereSet(this.indexID, this.operation, (char[][])new char[][]{kw}, new int[]{this.weight}));
        }
        if (((WhereSet)wheres.get(wheres.size() - 1)).getOperation() != 10) {
            wheres.add(0, new WhereSet(9));
            wheres.add(new WhereSet(10));
        }
        WhereSet[] whereSet = new WhereSet[wheres.size()];
        int i2 = 0;
        while (i2 < wheres.size()) {
            whereSet[i2] = (WhereSet)wheres.get(i2);
            ++i2;
        }
        return whereSet;
    }

    private char[] validateStr(String str) {
        char[] rStr = str.toCharArray();
        int start = 0;
        int end = rStr.length - 1;
        while (rStr[start] == ' ') {
            ++start;
        }
        while (rStr[end] == ' ') {
            --end;
        }
        char[] realStr = new char[end - start + 3];
        realStr[0] = 32;
        realStr[realStr.length - 1] = 32;
        System.arraycopy(rStr, start, realStr, 1, end - start + 1);
        return realStr;
    }

    private int[] getCutPos() {
        int pos = 0;
        int[] cutOffPos = new int[this.source.length];
        Arrays.fill(cutOffPos, -1);
        int i = 0;
        while (i < this.source.length) {
            char c = this.source[i];
            if ((c == '(' || c == ')' || c == '&' || c == '|' || c == '~') && this.source[i - 1] == ' ' && this.source[i + 1] == ' ') {
                cutOffPos[pos] = i;
                ++pos;
            }
            ++i;
        }
        return cutOffPos;
    }

    public static void main(String[] args) {
        String keyword = "\ud55c\uad6d & \uc77c\ubcf8";
        QueryParser parser = new QueryParser("TITLE", 1, keyword, 100);
        WhereSet[] wheres = parser.getWhereSet();
        int i = 0;
        while (i < wheres.length) {
            System.out.println(wheres[i]);
            ++i;
        }
    }
}

