/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util;

import com.diquest.ir.util.encode.Encoder;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestHandler
extends HttpServletRequestWrapper {
    private static String WEB_SERVER = null;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String POST = "POST";
    private final String encoding;

    public RequestHandler(HttpServletRequest request, ServletContext application) {
        this(request, application, DEFAULT_CHARSET);
    }

    public RequestHandler(HttpServletRequest request, ServletContext application, String encoding) {
        super(request);
        this.getServerInfo(application);
        this.encoding = encoding;
        if (!WEB_SERVER.startsWith("JRun")) {
            try {
                if (this.encoding != null) {
                    request.setCharacterEncoding(this.encoding);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    private void getServerInfo(ServletContext application) {
        String containerName = application.getServerInfo();
        if (WEB_SERVER == null) {
            WEB_SERVER = containerName;
        }
    }

    public String getParameter(String name) {
        return this.getParameter(name, "", true);
    }

    public String[] getParameterValues(String name) {
        boolean isPost = this.isPost();
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                values[i] = this.encoding != null && !isPost ? Encoder.encodeAuto((String)values[i], (String)this.encoding) : (values[i] == null ? "" : values[i]);
                ++i;
            }
        }
        return values;
    }

    public String getParameter(String pName, String defaultValue) {
        String value = this.getParameter(pName, null, true);
        String retr = value == null || "".equals(value) || "null".equals(value) ? defaultValue : value;
        return retr;
    }

    public String getParameter(String pName, String defaultValue, boolean trim) {
        String value = super.getParameter(pName);
        if (value == null) {
            return defaultValue;
        }
        if (this.encoding != null && !this.isPost()) {
            value = Encoder.encodeAuto((String)value, (String)this.encoding);
        }
        if (trim) {
            return value.trim();
        }
        return value;
    }

    public String[] getParameterValues(String pName, String[] defaultValue) {
        String[] values = this.getParameterValues(pName);
        String[] retr = values == null || values.length == 0 ? defaultValue : values;
        return retr;
    }

    public boolean getBoolean(String sName, boolean defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        boolean retr = (value = value.trim().toUpperCase()).equals("TRUE") || value.equals("ON") || value.equals("1") ? true : (value.equals("FALSE") || value.equals("OFF") || value.equals("0") ? false : defaultValue);
        return retr;
    }

    public boolean[] getBooleanValues(String[] sName, boolean[] defaultValues) {
        boolean[] retres = new boolean[sName.length];
        int i = 0;
        while (i < sName.length) {
            retres[i] = this.getBoolean(sName[i], defaultValues[i]);
            ++i;
        }
        return retres;
    }

    public int getInteger(String sName, int defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String sName, long defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public float getFloat(String sName, float defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public double getDouble(String sName, double defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public char getCharacter(String sName, char defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return value.charAt(0);
    }

    public char getCharacter(String sName, int position, char defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return value.charAt(position);
    }

    public byte getByte(String sName, byte defaultValue) {
        String value = this.getParameter(sName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException ne) {
            return defaultValue;
        }
    }

    private boolean isPost() {
        return POST.equalsIgnoreCase(super.getMethod());
    }
}

