/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.util.report;

import com.diquest.ir.common.database.entity.feedback.FeedbackStatisticEntity;
import com.diquest.ir.common.feedback.FeedbackMethods;
import com.diquest.ir.util.common.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StatisticUtil {
    public static final int RANGE = 10;
    public static final int COUNT = 1;
    public static final int RATIO = 2;

    public static void makeComparisonLabelList(List timeList, List unitList, List labelList, List mapKeyList, Map labelMap, List functionIdx, int type) {
        if (functionIdx.size() == 1) {
            StatisticUtil.makeLineLabel(timeList, labelList, mapKeyList, labelMap, (Integer)functionIdx.get(0), 1);
        } else {
            int i = 0;
            int end = functionIdx.size();
            while (i < end) {
                StatisticUtil.makeLineLabel(timeList, labelList, mapKeyList, labelMap, (Integer)functionIdx.get(i), 1);
                ++i;
            }
        }
    }

    public static void makeComparisonRatioLabelList(List timeList, List unitList, List labelList, List mapKeyList, Map labelMap, List functionIdx, int type) {
        if (functionIdx.size() == 1) {
            StatisticUtil.makeLineLabel(timeList, labelList, mapKeyList, labelMap, (Integer)functionIdx.get(0), 2);
        } else {
            int i = 0;
            int end = functionIdx.size();
            while (i < end) {
                StatisticUtil.makeLineLabel(timeList, labelList, mapKeyList, labelMap, (Integer)functionIdx.get(i), 2);
                ++i;
            }
        }
    }

    public static List makeLineUnitLabel(List unitList, int type, Date startDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
        Date today = null;
        ArrayList cmpList = new ArrayList();
        int range = 0;
        try {
            if (startDate != null && endDate != null) {
                String start = sdf.format(startDate);
                String end = sdf.format(endDate);
                today = endDate;
                switch (type) {
                    case 1: {
                        range = DateUtil.daysBetween((String)start, (String)end);
                        sdf = new SimpleDateFormat("dd", Locale.KOREA);
                        break;
                    }
                    case 7: {
                        range = DateUtil.weeksBetween((String)start, (String)end);
                        sdf = new SimpleDateFormat("MM/dd", Locale.KOREA);
                        break;
                    }
                    case 30: {
                        range = DateUtil.monthsBetween((String)start, (String)end);
                        sdf = new SimpleDateFormat("MM'\uc6d4'", Locale.KOREA);
                    }
                }
            } else {
                range = 10;
                switch (type) {
                    case 1: {
                        today = DateUtil.getStartCurrentDay();
                        sdf = new SimpleDateFormat("dd", Locale.KOREA);
                        break;
                    }
                    case 7: {
                        today = DateUtil.getStartCurrentDay();
                        sdf = new SimpleDateFormat("MM/dd", Locale.KOREA);
                        break;
                    }
                    case 30: {
                        today = DateUtil.getStartCurrentMonth();
                        sdf = new SimpleDateFormat("MM'\uc6d4'", Locale.KOREA);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        StatisticUtil.makeUnitList(unitList, type, sdf, today, cmpList, range);
        return cmpList;
    }

    private static void makeUnitList(List unitList, int type, SimpleDateFormat sdf, Date today, List cmpList, int range) {
        SimpleDateFormat firstDay = new SimpleDateFormat("MM/\ndd", Locale.KOREA);
        int i = 0;
        while (i <= range) {
            Date cmpDay = null;
            String unitName = null;
            switch (type) {
                case 1: {
                    cmpDay = DateUtil.getStartBeforeDate((Date)today, (int)(range - i));
                    if (cmpDay.compareTo(DateUtil.getStartCurrentMonth((Date)cmpDay)) == 0) {
                        unitName = firstDay.format(cmpDay);
                        break;
                    }
                    unitName = sdf.format(cmpDay);
                    break;
                }
                case 7: {
                    cmpDay = DateUtil.getStartBeforeWeek((Date)today, (int)(range - i));
                    unitName = StatisticUtil.makeWeekLabel(sdf, cmpDay);
                    break;
                }
                case 30: {
                    cmpDay = DateUtil.getStartBeforeMonth((Date)today, (int)(range - i));
                    unitName = sdf.format(cmpDay);
                }
            }
            cmpList.add(cmpDay);
            unitList.add(unitName);
            ++i;
        }
    }

    public static List makeLineUnitLabel(List unitList, int type) {
        return StatisticUtil.makeLineUnitLabel(unitList, type, null, null);
    }

    private static String makeWeekLabel(SimpleDateFormat sdf, Date cmpDay) {
        Date startTime = DateUtil.getStartCurrentWeek((Date)cmpDay);
        Date endTime = new Date(DateUtil.getStartNextWeek((Date)cmpDay).getTime() - 1L);
        StringBuffer sb = new StringBuffer(sdf.format(startTime));
        sb.append(" ~\n").append(sdf.format(endTime));
        return sb.toString();
    }

    private static void makeLineLabel(List timeList, List labelList, List keyList, Map dataMap, Integer functionIdx, int type) {
        Iterator unitIt;
        ArrayList<String> data;
        boolean isMade = false;
        Iterator keyIt = keyList.iterator();
        while (keyIt.hasNext()) {
            isMade = true;
            data = new ArrayList();
            unitIt = timeList.iterator();
            FeedbackStatisticEntity[] entities = (FeedbackStatisticEntity[])dataMap.get(keyIt.next());
            if (entities.length < 1) {
                while (unitIt.hasNext()) {
                    unitIt.next();
                    data.add("0");
                }
                labelList.add(data);
                continue;
            }
            int i = 0;
            int end = entities.length;
            while (i < end) {
                long basis = entities[i].getUnit();
                while (unitIt.hasNext()) {
                    Date cmpDate = (Date)unitIt.next();
                    if (cmpDate.getTime() < basis) {
                        data.add("0");
                        continue;
                    }
                    int[] functionCnts = entities[i].getFunctionCnt();
                    data.add(StatisticUtil.getFunctiondData(functionIdx, functionCnts, type));
                    break;
                }
                ++i;
            }
            while (data.size() != timeList.size()) {
                data.add("0");
            }
            labelList.add(data);
        }
        if (!isMade) {
            data = new ArrayList<String>();
            unitIt = timeList.iterator();
            while (data.size() != timeList.size()) {
                data.add("0");
            }
            labelList.add(data);
        }
    }

    private static String getFunctiondData(Integer functionIdx, int[] functionCnts, int type) {
        if (type == 1) {
            return String.valueOf(functionCnts[functionIdx]);
        }
        int total = StatisticUtil.calculateTotal(functionCnts);
        double val = (double)functionCnts[functionIdx] / (double)total * 100.0;
        return String.valueOf(val);
    }

    public static void makeFunctionRecentLabelList(List labelList, int functionIdx, FeedbackStatisticEntity recentResult) {
        int total = 0;
        if (recentResult != null) {
            total = StatisticUtil.calculateTotal(recentResult.getFunctionCnt());
        }
        StatisticUtil.makeRecentRatioLabel(labelList, functionIdx, recentResult, total);
    }

    private static int calculateTotal(int[] recentResult) {
        int total = 0;
        int i = 0;
        int end = recentResult.length;
        while (i < end) {
            total += recentResult[i];
            ++i;
        }
        return total;
    }

    private static void makeRecentRatioLabel(List labelList, int functionIdx, FeedbackStatisticEntity entities, int total) {
        int[] functionCnts = null;
        if (entities != null) {
            functionCnts = entities.getFunctionCnt();
        }
        List label = StatisticUtil.fillRecentRatioValue(functionIdx, total, functionCnts);
        labelList.add(label);
    }

    private static List fillRecentRatioValue(int functionIdx, int total, int[] functionCnts) {
        ArrayList<String> label = new ArrayList<String>();
        double ratio = 0.0;
        if (functionIdx != -1) {
            if (functionCnts != null) {
                ratio = (double)functionCnts[functionIdx] / (double)total * 100.0;
            }
            label.add(String.valueOf(ratio));
        } else {
            int i = 0;
            int end = FeedbackMethods.FUNCTION_IDS.length;
            while (i < end) {
                if (functionCnts != null) {
                    ratio = (double)functionCnts[i] / (double)total * 100.0;
                }
                label.add(String.valueOf(ratio));
                ++i;
            }
        }
        return label;
    }
}

