/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.setting.profile.ProfileSetting;
import com.diquest.ir.common.setting.profile.ProfileType;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class CollectionProfileSet
extends Transmitable {
    public static final String DFLT_DEFAULT_PROFILE_ID = "*";
    private static final String RESERVED = "(),";
    private final Set collections;
    private final Map profiles;
    private String defaultProfileId;

    public CollectionProfileSet() {
        this(DFLT_DEFAULT_PROFILE_ID);
    }

    public CollectionProfileSet(String defaultProfileId) {
        this.checkReserved(defaultProfileId);
        this.collections = new HashSet();
        this.profiles = new HashMap();
        this.defaultProfileId = defaultProfileId;
    }

    private void checkReserved(String str) {
        int i = 0;
        while (i < RESERVED.length()) {
            if (str.indexOf(RESERVED.charAt(i)) >= 0) {
                throw new IllegalArgumentException("\"" + str + "\" is not a proper default profile ID.");
            }
            ++i;
        }
    }

    public void addAllProfiles(String collection, ProfileSetting setting) {
        this.collections.remove(collection);
        this.ensure(collection);
        Set profs = (Set)this.profiles.get(collection);
        Iterator it = setting.getProfile().iterator();
        while (it.hasNext()) {
            ProfileType pt = (ProfileType)it.next();
            profs.add(pt.getId());
        }
        if (this.defaultProfileId != null) {
            profs.add(this.defaultProfileId);
        }
    }

    public void addCollection(String collection) {
        this.profiles.remove(collection);
        this.collections.add(collection);
    }

    public void addProfile(String collection, String profile) {
        if (this.collections.contains(collection)) {
            throw new IllegalArgumentException();
        }
        this.ensure(collection);
        ((Set)this.profiles.get(collection)).add(profile);
    }

    public boolean contains(String collection) {
        return this.collections.contains(collection) || this.profiles.get(collection) != null && !((Set)this.profiles.get(collection)).isEmpty();
    }

    public boolean contains(String collection, String profile, ProfileSetting setting) {
        if (this.collections.contains(collection) && this.validProfile(profile, setting)) {
            return true;
        }
        Set profs = (Set)this.profiles.get(collection);
        return profs != null && profs.contains(profile);
    }

    public boolean containsAll(String collection, ProfileSetting setting) {
        if (this.collections.contains(collection)) {
            return true;
        }
        Set profs = (Set)this.profiles.get(collection);
        if (profs == null) {
            return false;
        }
        Iterator it = setting.getProfile().iterator();
        while (it.hasNext()) {
            ProfileType pt = (ProfileType)it.next();
            if (profs.contains(pt.getId())) continue;
            return false;
        }
        if (this.defaultProfileId != null) {
            return profs.contains(this.defaultProfileId);
        }
        return false;
    }

    public void clear() {
        this.collections.clear();
        this.profiles.clear();
    }

    public CollectionProfileSet decode(String set) {
        this.clear();
        StringTokenizer tokenizer = new StringTokenizer(set, RESERVED, true);
        String collection = null;
        String profile = null;
        int status = 99;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (status) {
                case 0: {
                    collection = token;
                    status = 1;
                    break;
                }
                case 1: {
                    if (token.equals(",")) {
                        this.addCollection(collection);
                        status = 0;
                        break;
                    }
                    if (token.equals("(")) {
                        status = 2;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 2: {
                    if (token.equals(")")) {
                        status = 4;
                        break;
                    }
                    profile = token;
                    this.addProfile(collection, profile);
                    status = 3;
                    break;
                }
                case 3: {
                    if (token.equals(",")) {
                        status = 2;
                        break;
                    }
                    if (token.equals(")")) {
                        status = 4;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 4: {
                    if (token.equals(",")) {
                        status = 0;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 99: {
                    if (!token.equals(",")) {
                        this.defaultProfileId = token;
                    }
                    status = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return this;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        if (this.defaultProfileId != null) {
            sb.append(this.defaultProfileId);
        }
        sb.append(",");
        Iterator<Object> it = this.collections.iterator();
        while (it.hasNext()) {
            String collection = (String)it.next();
            sb.append(collection);
            sb.append(',');
        }
        this.profiles.keySet().removeAll(this.collections);
        it = this.profiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String collection = (String)entry.getKey();
            Set profs = (Set)entry.getValue();
            sb.append(collection);
            sb.append('(');
            Iterator pr = profs.iterator();
            while (pr.hasNext()) {
                String p = (String)pr.next();
                sb.append(p);
                sb.append(',');
            }
            sb.append(')');
            sb.append(',');
        }
        return sb.toString();
    }

    public void removeCollection(String collection) {
        this.profiles.remove(collection);
        this.collections.remove(collection);
    }

    public void removeProfile(String collection, String profile) {
        if (this.collections.contains(collection)) {
            throw new IllegalArgumentException();
        }
        Set profs = (Set)this.profiles.get(collection);
        if (profs != null) {
            profs.remove(profile);
        }
    }

    private void ensure(String collection) {
        if (this.profiles.get(collection) == null) {
            this.profiles.put(collection, new HashSet());
        }
    }

    private boolean validProfile(String profile, ProfileSetting setting) {
        if (this.defaultProfileId != null && this.defaultProfileId.equals(profile)) {
            return true;
        }
        Iterator it = setting.getProfile().iterator();
        while (it.hasNext()) {
            ProfileType pt = (ProfileType)it.next();
            if (!pt.getId().equals(profile)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collections == null ? 0 : this.collections.hashCode());
        result = 31 * result + (this.defaultProfileId == null ? 0 : this.defaultProfileId.hashCode());
        result = 31 * result + (this.profiles == null ? 0 : this.profiles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionProfileSet)) {
            return false;
        }
        CollectionProfileSet other = (CollectionProfileSet)((Object)obj);
        if (this.collections == null ? other.collections != null : !this.collections.equals(other.collections)) {
            return false;
        }
        if (this.defaultProfileId == null ? other.defaultProfileId != null : !this.defaultProfileId.equals(other.defaultProfileId)) {
            return false;
        }
        return !(this.profiles == null ? other.profiles != null : !this.profiles.equals(other.profiles));
    }

    public String toString() {
        return "[defaultProfileId=" + this.defaultProfileId + ", collections=" + this.collections + ", profiles=" + this.profiles + "]";
    }

    public void deserialize(InputStream in) throws IOException {
        this.clear();
        this.defaultProfileId = ByteUtil.readString((InputStream)in);
        int numCollection = ByteUtil.readInt((InputStream)in);
        int i = 0;
        while (i < numCollection) {
            this.addCollection(ByteUtil.readString((InputStream)in));
            ++i;
        }
        int numProfileCollections = ByteUtil.readInt((InputStream)in);
        int i2 = 0;
        while (i2 < numProfileCollections) {
            String collection = ByteUtil.readString((InputStream)in);
            int numProfiles = ByteUtil.readInt((InputStream)in);
            int j = 0;
            while (j < numProfiles) {
                this.addProfile(collection, ByteUtil.readString((InputStream)in));
                ++j;
            }
            ++i2;
        }
    }

    public Transmitable getInstance() {
        return new CollectionProfileSet();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.defaultProfileId);
        ByteUtil.writeInt((OutputStream)out, (int)this.collections.size());
        Iterator<Object> it = this.collections.iterator();
        while (it.hasNext()) {
            String collection = (String)it.next();
            ByteUtil.writeString((OutputStream)out, (String)collection);
        }
        this.profiles.keySet().removeAll(this.collections);
        ByteUtil.writeInt((OutputStream)out, (int)this.profiles.size());
        it = this.profiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String collection = (String)entry.getKey();
            Set profs = (Set)entry.getValue();
            ByteUtil.writeString((OutputStream)out, (String)collection);
            ByteUtil.writeInt((OutputStream)out, (int)profs.size());
            Iterator pr = profs.iterator();
            while (pr.hasNext()) {
                String p = (String)pr.next();
                ByteUtil.writeString((OutputStream)out, (String)p);
            }
        }
    }

    public CollectionProfileIterator getIterator() {
        return new CollectionProfileIterator(this);
    }

    public class CollectionProfileIterator {
        private final Iterator citerator;
        private final Iterator cpiterator;
        private Iterator piterator;
        private String last;
        private final CollectionProfileSet cps;

        CollectionProfileIterator(CollectionProfileSet cps) {
            this.citerator = cps.collections.iterator();
            this.cpiterator = cps.profiles.keySet().iterator();
            this.cps = cps;
            this.last = null;
        }

        public String nextCollection() {
            this.piterator = null;
            if (this.citerator.hasNext()) {
                return (String)this.citerator.next();
            }
            this.last = (String)this.cpiterator.next();
            this.piterator = ((Set)this.cps.profiles.get(this.last)).iterator();
            return this.last;
        }

        public boolean hasNextCollection() {
            if (this.citerator.hasNext()) {
                return true;
            }
            return this.cpiterator.hasNext();
        }

        public boolean hasNextProfile() {
            if (this.piterator == null) {
                return false;
            }
            return this.piterator.hasNext();
        }

        public String nextProfile() {
            if (this.piterator == null) {
                throw new NoSuchElementException();
            }
            return (String)this.piterator.next();
        }
    }
}

