/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TaskMonitorKey
extends Transmitable {
    public static final byte STATUS_START = 1;
    public static final byte STATUS_PROC = 2;
    public static final byte STATUS_END = 3;
    public static final byte STATUS_NONE = 16;
    private String taskName;
    private byte status;

    public static String statusToString(byte status) {
        if (status == 1) {
            return "START";
        }
        if (status == 2) {
            return "PROC";
        }
        if (status == 3) {
            return "END";
        }
        if (status == 16) {
            return "NONE-SET";
        }
        return "";
    }

    public TaskMonitorKey() {
    }

    public TaskMonitorKey(String taskName, byte status) {
        this.taskName = taskName;
        this.status = status;
    }

    public void deserialize(InputStream in) throws IOException {
        this.taskName = ByteUtil.readString((InputStream)in);
        this.status = ByteUtil.readByte((InputStream)in);
    }

    public Transmitable getInstance() {
        return new TaskMonitorKey();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.taskName);
        ByteUtil.writeByte((OutputStream)out, (byte)this.status);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }
}

