/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database;

import java.util.List;

public class SqlAppendUtil {
    public static void appendOnlyWhereCond(StringBuffer buf, String column, String operator) {
        SqlAppendUtil.appendWhereCond(buf, column, operator, true, true);
    }

    public static void appendFirstWhereCond(StringBuffer buf, String column, String operator) {
        SqlAppendUtil.appendWhereCond(buf, column, operator, true, false);
    }

    public static void appendMiddleWhereCond(StringBuffer buf, String column, String operator) {
        SqlAppendUtil.appendWhereCond(buf, column, operator, false, false);
    }

    public static void appendLastWhereCond(StringBuffer buf, String column, String operator) {
        SqlAppendUtil.appendWhereCond(buf, column, operator, false, true);
    }

    private static void appendWhereCond(StringBuffer buf, String column, String operator, boolean isFirst, boolean isLast) {
        if (isFirst) {
            buf.append(" where ");
        }
        buf.append(column);
        buf.append(operator);
        buf.append(" ? ");
        if (!isLast) {
            buf.append(" and ");
        }
    }

    public static void appendOnlyWhereDef(StringBuffer buf, String column, String operator, String def, boolean isBackticks) {
        SqlAppendUtil.appendWhereDef(buf, column, operator, true, true, def, isBackticks);
    }

    public static void appendFirstWhereDef(StringBuffer buf, String column, String operator, String def, boolean isBackticks) {
        SqlAppendUtil.appendWhereDef(buf, column, operator, true, false, def, isBackticks);
    }

    public static void appendMiddleWhereDef(StringBuffer buf, String column, String operator, String def, boolean isBackticks) {
        SqlAppendUtil.appendWhereDef(buf, column, operator, false, false, def, isBackticks);
    }

    public static void appendLastWhereDef(StringBuffer buf, String column, String operator, String def, boolean isBackticks) {
        SqlAppendUtil.appendWhereDef(buf, column, operator, false, true, def, isBackticks);
    }

    private static void appendWhereDef(StringBuffer buf, String column, String operator, boolean isFirst, boolean isLast, String def, boolean isBackticks) {
        if (isFirst) {
            buf.append(" where ");
        }
        buf.append(column);
        buf.append(operator);
        if (isBackticks) {
            buf.append("'").append(def).append("'");
        } else {
            buf.append(def);
        }
        if (!isLast) {
            buf.append(" and ");
        }
    }

    public static void appendFirstInWhereCond(StringBuffer buf, String column, int size) {
        SqlAppendUtil.appendInWhereCond(buf, column, size, true, false);
    }

    public static void appendMiddleInWhereCond(StringBuffer buf, String column, int size) {
        SqlAppendUtil.appendInWhereCond(buf, column, size, false, false);
    }

    public static void appendLastInWhereCond(StringBuffer buf, String column, int size) {
        SqlAppendUtil.appendInWhereCond(buf, column, size, false, true);
    }

    public static void appendOnlyInWhereCond(StringBuffer buf, String column, int size) {
        SqlAppendUtil.appendInWhereCond(buf, column, size, true, true);
    }

    public static void appendInWhereCond(StringBuffer buf, String column, int size, boolean isFirst, boolean isLast) {
        if (isFirst) {
            buf.append(" where ");
        }
        buf.append(column).append(" in (");
        int i = 0;
        while (i < size) {
            if (size != i + 1) {
                buf.append("?, ");
            } else {
                buf.append("? ) ");
            }
            ++i;
        }
        if (!isLast) {
            buf.append(" and ");
        }
    }

    public static void appendFirstInWhereDef(StringBuffer buf, String column, List definitions, boolean isBackticks) {
        SqlAppendUtil.appendInWhereDef(buf, column, true, false, definitions, isBackticks);
    }

    public static void appendMiddleInWhereDef(StringBuffer buf, String column, List definitions, boolean isBackticks) {
        SqlAppendUtil.appendInWhereDef(buf, column, false, false, definitions, isBackticks);
    }

    public static void appendLastInWhereDef(StringBuffer buf, String column, List definitions, boolean isBackticks) {
        SqlAppendUtil.appendInWhereDef(buf, column, false, true, definitions, isBackticks);
    }

    public static void appendOnlyInWhereDef(StringBuffer buf, String column, List definitions, boolean isBackticks) {
        SqlAppendUtil.appendInWhereDef(buf, column, true, true, definitions, isBackticks);
    }

    public static void appendInWhereDef(StringBuffer buf, String column, boolean isFirst, boolean isLast, List definitions, boolean isBackticks) {
        int size = definitions.size();
        if (isFirst) {
            buf.append(" where ");
        }
        buf.append(column).append(" in (");
        int i = 0;
        while (i < size) {
            if (isBackticks) {
                buf.append("'").append(definitions.get(i)).append("'");
            } else {
                buf.append(definitions.get(i));
            }
            if (size != i + 1) {
                buf.append(", ");
            } else {
                buf.append(" ) ");
            }
            ++i;
        }
        if (!isLast) {
            buf.append(" and ");
        }
    }

    public static void appendDelete(StringBuffer buf, String tablename) {
        buf.append("DELETE FROM ").append(tablename).append(" ");
    }

    public static String appendGroupBy(String[] columns) {
        StringBuffer buf = new StringBuffer(" GROUP BY ");
        int size = columns.length;
        int i = 0;
        while (i < size) {
            buf.append(columns[i]);
            if (size != i + 1) {
                buf.append(", ");
            } else {
                buf.append(" ");
            }
            ++i;
        }
        return buf.toString();
    }

    public static void appendGroupBy(StringBuffer buf, String[] columns) {
        buf.append(" GROUP BY ");
        int size = columns.length;
        int i = 0;
        while (i < size) {
            buf.append(columns[i]);
            if (size != i + 1) {
                buf.append(", ");
            } else {
                buf.append(" ");
            }
            ++i;
        }
    }
}

