/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.AbstractQueryLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractKeywordCountQueryLog
extends AbstractQueryLog {
    public static final int DIFFERENCE_NEW = Integer.MIN_VALUE;
    public static final int RANK_UNKNOWN = -1;
    static final Comparator LOG_KEYWORD_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            AbstractKeywordCountQueryLog o1 = (AbstractKeywordCountQueryLog)arg0;
            AbstractKeywordCountQueryLog o2 = (AbstractKeywordCountQueryLog)arg1;
            return o1.getKeywords().compareTo(o2.getKeywords());
        }
    };
    static final Comparator LOG_CPK_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            AbstractKeywordCountQueryLog o1 = (AbstractKeywordCountQueryLog)arg0;
            AbstractKeywordCountQueryLog o2 = (AbstractKeywordCountQueryLog)arg1;
            int diff = o1.collection.compareTo(o2.collection);
            if (diff != 0) {
                return diff;
            }
            diff = o1.profile.compareTo(o2.profile);
            if (diff != 0) {
                return diff;
            }
            diff = o1.keywords.compareTo(o2.keywords);
            return diff;
        }
    };
    static final Comparator LOG_REQUESTED_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            AbstractKeywordCountQueryLog o1 = (AbstractKeywordCountQueryLog)arg0;
            AbstractKeywordCountQueryLog o2 = (AbstractKeywordCountQueryLog)arg1;
            int diff = o1.requested - o2.requested;
            if (diff != 0) {
                return diff;
            }
            diff = o1.collection.compareTo(o2.collection);
            if (diff != 0) {
                return diff;
            }
            diff = o1.profile.compareTo(o2.profile);
            if (diff != 0) {
                return diff;
            }
            diff = o1.keywords.compareTo(o2.keywords);
            return diff;
        }
    };
    private transient int difference;
    private transient int rank = -1;
    protected String keywords = "";
    protected long duration;
    protected int requested;

    public static void referRankFrom(List unranked, List ranked) {
        Iterator ui = unranked.iterator();
        Iterator ri = ranked.iterator();
        while (ui.hasNext()) {
            boolean found = false;
            AbstractKeywordCountQueryLog uLog = (AbstractKeywordCountQueryLog)ui.next();
            while (ri.hasNext()) {
                AbstractKeywordCountQueryLog rLog = (AbstractKeywordCountQueryLog)ri.next();
                if (!uLog.equals(rLog)) continue;
                uLog.setRank(rLog.getRank());
                found = true;
                break;
            }
            if (found) continue;
            uLog.setRank(-1);
            break;
        }
        while (ui.hasNext()) {
            AbstractKeywordCountQueryLog uLog = (AbstractKeywordCountQueryLog)ui.next();
            uLog.setRank(-1);
        }
    }

    public AbstractKeywordCountQueryLog() {
    }

    public AbstractKeywordCountQueryLog(AbstractKeywordCountQueryLog abstractKeywordCountQueryLog) {
        super(abstractKeywordCountQueryLog);
        this.difference = abstractKeywordCountQueryLog.difference;
        this.rank = abstractKeywordCountQueryLog.rank;
        this.keywords = abstractKeywordCountQueryLog.keywords;
        this.duration = abstractKeywordCountQueryLog.duration;
        this.requested = abstractKeywordCountQueryLog.requested;
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.setKeywords(ByteUtil.readString((InputStream)in));
        this.setDuration(ByteUtil.readLong((InputStream)in));
        this.setRequested(ByteUtil.readInt((InputStream)in));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractKeywordCountQueryLog) {
            AbstractKeywordCountQueryLog log = (AbstractKeywordCountQueryLog)obj;
            return StringUtil.equals((String)this.keywords, (String)log.keywords) && this.requested == log.requested && this.duration == log.duration && super.equals(log);
        }
        return false;
    }

    public final int getDifference() {
        return this.difference;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final String getKeywords() {
        return this.keywords;
    }

    public final int getRank() {
        return this.rank;
    }

    public final int getRequested() {
        return this.requested;
    }

    public int hashCode() {
        return super.hashCode() ^ (this.keywords != null ? this.keywords.hashCode() : 0) ^ (int)this.duration ^ this.requested;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeString((OutputStream)out, (String)this.keywords);
        ByteUtil.writeLong((OutputStream)out, (long)this.duration);
        ByteUtil.writeInt((OutputStream)out, (int)this.requested);
    }

    public final void setDifference(int difference) {
        this.difference = difference;
    }

    public final void setDuration(long duration) {
        this.duration = duration;
    }

    public final void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public final void setRank(int rank) {
        this.rank = rank;
    }

    public final void setRequested(int requested) {
        this.requested = requested;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append("[");
        String superString = super.toString();
        if (superString.length() != 0) {
            buf.append(superString);
            buf.append(", ");
        }
        buf.append("keywords=");
        buf.append(this.keywords);
        buf.append(", duration=");
        buf.append(this.duration);
        buf.append(", requested=");
        buf.append(this.requested);
        buf.append(']');
        return buf.toString();
    }

    public List merge(List o1, List o2, boolean disposable) {
        AbstractKeywordCountQueryLog[] a1 = new AbstractKeywordCountQueryLog[o1.size()];
        o1.toArray(a1);
        if (disposable) {
            o1.clear();
            o1 = null;
        }
        AbstractKeywordCountQueryLog[] a2 = new AbstractKeywordCountQueryLog[o2.size()];
        o2.toArray(a2);
        if (disposable) {
            o2.clear();
            o2 = null;
        }
        Arrays.sort(a1, LOG_CPK_COMPARATOR);
        Arrays.sort(a2, LOG_CPK_COMPARATOR);
        ArrayList<AbstractKeywordCountQueryLog> merged = new ArrayList<AbstractKeywordCountQueryLog>(a1.length + a2.length);
        int i1 = 0;
        int i2 = 0;
        while (i1 < a1.length && i2 < a2.length) {
            int compare = LOG_CPK_COMPARATOR.compare(a1[i1], a2[i2]);
            if (compare < 0) {
                merged.add(this.copy(a1[i1++]));
                continue;
            }
            if (compare > 0) {
                merged.add(this.copy(a2[i2++]));
                continue;
            }
            AbstractKeywordCountQueryLog log = this.copy(a1[i1]);
            log.setRequested(a1[i1].requested + a2[i2].requested);
            ++i1;
            ++i2;
        }
        while (i1 < a1.length) {
            merged.add(this.copy(a1[i1++]));
            ++i1;
        }
        while (i2 < a2.length) {
            merged.add(this.copy(a2[i2++]));
            ++i2;
        }
        return merged;
    }

    public static void sortByRequested(List list, boolean desc) {
        Collections.sort(list, LOG_REQUESTED_COMPARATOR);
        if (desc) {
            Collections.reverse(list);
        }
    }

    public abstract AbstractKeywordCountQueryLog copy(AbstractKeywordCountQueryLog var1);
}

