/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.AbstractLog;
import com.diquest.ir.common.database.entity.TimeLimited;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public abstract class AbstractQueryLog
extends AbstractLog
implements TimeLimited {
    protected String collection;
    protected String profile;
    protected long registered;

    protected AbstractQueryLog() {
    }

    protected AbstractQueryLog(AbstractQueryLog log) {
        this.collection = log.collection;
        this.profile = log.profile;
        this.registered = log.registered;
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.setCollection(ByteUtil.readString((InputStream)in));
        this.setProfile(ByteUtil.readString((InputStream)in));
        this.setRegistered(ByteUtil.readLong((InputStream)in));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractQueryLog) {
            AbstractQueryLog log = (AbstractQueryLog)obj;
            return StringUtil.equals((String)this.collection, (String)log.collection) && StringUtil.equals((String)this.profile, (String)log.profile) && this.registered == log.registered && super.equals(log);
        }
        return false;
    }

    public final String getCollection() {
        return this.collection;
    }

    public final String getCollectionId() {
        return this.collection;
    }

    public final String getProfile() {
        return this.profile;
    }

    public final long getRegistered() {
        return this.registered;
    }

    public final long getTime() {
        return this.registered;
    }

    public int hashCode() {
        return super.hashCode() ^ (this.collection == null ? 0 : this.collection.hashCode()) ^ (this.profile == null ? 0 : this.profile.hashCode()) ^ (int)this.registered;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeString((OutputStream)out, (String)this.collection);
        ByteUtil.writeString((OutputStream)out, (String)this.profile);
        ByteUtil.writeLong((OutputStream)out, (long)this.registered);
    }

    public final void setCollection(String collection) {
        this.collection = collection;
    }

    public final void setProfile(String profile) {
        this.profile = profile;
    }

    public final void setRegistered(long registered) {
        this.registered = registered;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        String superString = super.toString();
        if (superString.length() != 0) {
            buf.append(superString);
            buf.append(", ");
        }
        buf.append("collection=");
        buf.append(this.collection);
        buf.append(", profile=");
        buf.append(this.profile);
        buf.append(", registered=");
        buf.append((Object)new Date(this.registered));
        buf.append("]");
        return buf.toString();
    }
}

