/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.ir.common.database.entity.ProfileAuthority;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CollectionAuthority
extends Transmitable
implements Serializable {
    private static final long serialVersionUID = 2656257313016200111L;
    private String collectionName;
    private char collectionAuth;
    private List profileAuthorities;

    public CollectionAuthority() {
        this.profileAuthorities = new ArrayList();
    }

    public CollectionAuthority(String collectionName, char auth) {
        this.collectionName = collectionName;
        this.collectionAuth = auth;
        this.profileAuthorities = new ArrayList();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public char getCollectionAuth() {
        return this.collectionAuth;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setCollectionAuth(char collectionAuth) {
        this.collectionAuth = collectionAuth;
    }

    public void addProfileAuthority(String profileName, char auth) {
        this.addProfileAuthority(new ProfileAuthority(profileName, auth));
    }

    public void addProfileAuthority(ProfileAuthority auth) {
        if (this.profileAuthorities != null) {
            if (this.profileAuthorities.size() == 0) {
                this.profileAuthorities.add(auth);
            } else {
                int i = 0;
                while (i < this.profileAuthorities.size()) {
                    if (((ProfileAuthority)this.profileAuthorities.get(i)).getProfileName().equals(auth.getProfileName())) {
                        this.profileAuthorities.remove(i);
                        break;
                    }
                    ++i;
                }
                this.profileAuthorities.add(auth);
            }
        }
    }

    public void removeProfileAuthority(String profileName) {
        if (this.profileAuthorities != null && this.profileAuthorities.size() != 0) {
            int i = 0;
            while (i < this.profileAuthorities.size()) {
                ProfileAuthority pAuth = (ProfileAuthority)this.profileAuthorities.get(i);
                if (pAuth.getProfileName().equals(profileName)) {
                    this.profileAuthorities.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public char getProfileAuthorityValue(String profileName) {
        if (this.profileAuthorities != null && this.profileAuthorities.size() != 0) {
            int i = 0;
            while (i < this.profileAuthorities.size()) {
                ProfileAuthority pAuth = (ProfileAuthority)this.profileAuthorities.get(i);
                if (pAuth.getProfileName().equals(profileName)) {
                    return pAuth.getAuth();
                }
                ++i;
            }
        }
        return 'N';
    }

    public ProfileAuthority getProfileAuthority(String profileName) {
        if (this.profileAuthorities != null && this.profileAuthorities.size() != 0) {
            int i = 0;
            while (i < this.profileAuthorities.size()) {
                ProfileAuthority pAuth = (ProfileAuthority)this.profileAuthorities.get(i);
                if (pAuth.getProfileName().equals(profileName)) {
                    return pAuth;
                }
                ++i;
            }
        }
        return null;
    }

    public void deserialize(InputStream in) throws IOException {
        this.collectionName = ByteUtil.readString((InputStream)in);
        this.collectionAuth = ByteUtil.readChar((InputStream)in);
        int size = ByteUtil.readInt((InputStream)in);
        int i = 0;
        while (i < size) {
            ProfileAuthority pAuth = new ProfileAuthority();
            pAuth.deserialize(in);
            this.profileAuthorities.add(pAuth);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new CollectionAuthority();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.collectionName);
        ByteUtil.writeChar((OutputStream)out, (char)this.collectionAuth);
        if (this.profileAuthorities == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.profileAuthorities.size());
            int i = 0;
            while (i < this.profileAuthorities.size()) {
                ProfileAuthority pAuth = (ProfileAuthority)this.profileAuthorities.get(i);
                pAuth.serialize(out);
                ++i;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.collectionAuth;
        result = 31 * result + (this.collectionName == null ? 0 : this.collectionName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionAuthority other = (CollectionAuthority)obj;
        if (this.collectionAuth != other.collectionAuth) {
            return false;
        }
        return !(this.collectionName == null ? other.collectionName != null : !this.collectionName.equals(other.collectionName));
    }
}

