/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.ir.common.database.entity.CollectionAuthority;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CollectionAuthoritySet
extends Transmitable
implements Serializable {
    private static final long serialVersionUID = 6407787894601178082L;
    private List collectionAuthorities;

    public CollectionAuthoritySet() {
        this.collectionAuthorities = new ArrayList();
    }

    public CollectionAuthoritySet(List collectionAuths) {
        this.collectionAuthorities = collectionAuths;
    }

    public void addCollectionAuthority(String collectionName, char auth) {
        this.addCollectionAuthority(new CollectionAuthority(collectionName, auth));
    }

    public void addCollectionAuthority(CollectionAuthority auth) {
        if (this.collectionAuthorities != null) {
            if (this.collectionAuthorities.size() == 0) {
                this.collectionAuthorities.add(auth);
            } else {
                int i = 0;
                while (i < this.collectionAuthorities.size()) {
                    if (((CollectionAuthority)this.collectionAuthorities.get(i)).getCollectionName().equals(auth.getCollectionName())) {
                        this.collectionAuthorities.remove(i);
                        break;
                    }
                    ++i;
                }
                this.collectionAuthorities.add(auth);
            }
        }
    }

    public void modifyCollectionAuthority(String collectionName, char auth) {
        if (this.collectionAuthorities != null && this.collectionAuthorities.size() != 0) {
            int i = 0;
            while (i < this.collectionAuthorities.size()) {
                CollectionAuthority cAuth = (CollectionAuthority)this.collectionAuthorities.get(i);
                if (cAuth.getCollectionName().equals(collectionName)) {
                    cAuth.setCollectionAuth(auth);
                    this.addCollectionAuthority(cAuth);
                    return;
                }
                ++i;
            }
        }
    }

    public void removeCollectionAuthority(String collectionName) {
        if (this.collectionAuthorities != null && this.collectionAuthorities.size() != 0) {
            int i = 0;
            while (i < this.collectionAuthorities.size()) {
                CollectionAuthority cAuth = (CollectionAuthority)this.collectionAuthorities.get(i);
                if (cAuth.getCollectionName().equals(collectionName)) {
                    this.collectionAuthorities.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public char getCollectionAuthorityValue(String collectionName) {
        if (this.collectionAuthorities != null && this.collectionAuthorities.size() != 0) {
            int i = 0;
            while (i < this.collectionAuthorities.size()) {
                CollectionAuthority cAuth = (CollectionAuthority)this.collectionAuthorities.get(i);
                if (cAuth.getCollectionName().equals(collectionName)) {
                    return cAuth.getCollectionAuth();
                }
                ++i;
            }
        }
        return 'N';
    }

    public CollectionAuthority getCollectionAuthority(String collectionName) {
        if (this.collectionAuthorities != null && this.collectionAuthorities.size() != 0) {
            int i = 0;
            while (i < this.collectionAuthorities.size()) {
                CollectionAuthority cAuth = (CollectionAuthority)this.collectionAuthorities.get(i);
                if (cAuth.getCollectionName().equals(collectionName)) {
                    return cAuth;
                }
                ++i;
            }
        }
        return null;
    }

    public char getProfileAuthorityValue(String collectionName, String profileName) {
        if (this.collectionAuthorities != null && this.collectionAuthorities.size() != 0) {
            int i = 0;
            while (i < this.collectionAuthorities.size()) {
                CollectionAuthority cAuth = (CollectionAuthority)this.collectionAuthorities.get(i);
                if (cAuth.getCollectionName().equals(collectionName)) {
                    return cAuth.getProfileAuthorityValue(profileName);
                }
                ++i;
            }
            return 'N';
        }
        return 'N';
    }

    public int getNumCollectionAuth() {
        return this.collectionAuthorities.size();
    }

    public List getCollectionAuthorities() {
        return this.collectionAuthorities;
    }

    public void setCollectionAuthorities(List collectionAuthoroties) {
        this.collectionAuthorities = collectionAuthoroties;
    }

    public Transmitable getInstance() {
        return new CollectionAuthoritySet();
    }

    public boolean isNull() {
        return false;
    }

    public void deserialize(InputStream in) throws IOException {
        int size = ByteUtil.readInt((InputStream)in);
        int i = 0;
        while (i < size) {
            CollectionAuthority cAuth = new CollectionAuthority();
            cAuth.deserialize(in);
            this.collectionAuthorities.add(cAuth);
            ++i;
        }
    }

    public void serialize(OutputStream out) throws IOException {
        if (this.collectionAuthorities == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.collectionAuthorities.size());
            int i = 0;
            while (i < this.collectionAuthorities.size()) {
                CollectionAuthority cAuth = (CollectionAuthority)this.collectionAuthorities.get(i);
                cAuth.serialize(out);
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        CollectionAuthoritySet cSet = new CollectionAuthoritySet();
        CollectionAuthority auth1 = new CollectionAuthority("collection1", 'W');
        CollectionAuthority auth2 = new CollectionAuthority("collection2", 'R');
        cSet.addCollectionAuthority(auth1);
        cSet.addCollectionAuthority(auth2);
        cSet.addCollectionAuthority(auth2);
        System.out.println(cSet.getNumCollectionAuth());
        CollectionAuthority auth3 = new CollectionAuthority("collection2", 'N');
        cSet.addCollectionAuthority(auth3);
        System.out.println(cSet.getNumCollectionAuth());
    }
}

