/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class CollectionMonitor
extends Transmitable {
    public static final char STATE_ADDCOMPLETE = 'C';
    public static final char STATE_MODIFYING = 'M';
    public static final char STATE_OPERATING = 'O';
    public static final char STATE_OPERMODI = 'H';
    private String collectionID = null;
    private char collectionStatus = '\u0000';
    private char collectionStatusPrevious = '\u0000';
    private long lastModifiedDate = 0L;

    public CollectionMonitor() {
    }

    public CollectionMonitor(CollectionMonitor copy) {
        this.copyOf(copy);
    }

    public void copyOf(CollectionMonitor copy) {
        this.collectionID = copy.collectionID;
        this.collectionStatus = copy.collectionStatus;
        this.collectionStatusPrevious = copy.collectionStatusPrevious;
        this.lastModifiedDate = copy.lastModifiedDate;
    }

    public boolean isStable() {
        return this.collectionStatus == 'O' || this.collectionStatus == 'H' || this.collectionStatus == 'C';
    }

    public boolean isUnstable() {
        return this.collectionStatus == 'M';
    }

    public CollectionMonitor(String collectionID, char collectionStatus, char collectionStatusPrevious, long lastModifiedDate) {
        this.collectionID = collectionID;
        this.collectionStatus = collectionStatus;
        this.collectionStatusPrevious = collectionStatusPrevious;
        this.lastModifiedDate = lastModifiedDate;
    }

    public CollectionMonitor(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public char getCollectionStatus() {
        return this.collectionStatus;
    }

    public void setCollectionStatus(char collectionStatus) {
        this.collectionStatus = collectionStatus;
    }

    public char getCollectionStatusPrevious() {
        return this.collectionStatusPrevious;
    }

    public void setCollectionStatusPrevious(char collectionStatusPrevious) {
        this.collectionStatusPrevious = collectionStatusPrevious;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void deserialize(InputStream in) throws IOException {
        this.collectionID = ByteUtil.readString((InputStream)in);
        this.collectionStatus = ByteUtil.readChar((InputStream)in);
        this.collectionStatusPrevious = ByteUtil.readChar((InputStream)in);
        this.lastModifiedDate = ByteUtil.readLong((InputStream)in);
    }

    public Transmitable getInstance() {
        return new CollectionMonitor();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.collectionID);
        ByteUtil.writeChar((OutputStream)out, (char)this.collectionStatus);
        ByteUtil.writeChar((OutputStream)out, (char)this.collectionStatusPrevious);
        ByteUtil.writeLong((OutputStream)out, (long)this.lastModifiedDate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        CollectionMonitor castedObj = (CollectionMonitor)((Object)o);
        return (this.collectionID == null ? castedObj.collectionID == null : this.collectionID.equals(castedObj.collectionID)) && this.collectionStatus == castedObj.collectionStatus && this.collectionStatusPrevious == castedObj.collectionStatusPrevious && this.lastModifiedDate == castedObj.lastModifiedDate;
    }

    public boolean equalsExceptDate(CollectionMonitor o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((Object)((Object)o)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        CollectionMonitor castedObj = o;
        return (this.collectionID == null ? castedObj.collectionID == null : this.collectionID.equals(castedObj.collectionID)) && this.collectionStatus == castedObj.collectionStatus && this.collectionStatusPrevious == castedObj.collectionStatusPrevious;
    }

    public boolean equalsExceptDateAndPreviousStatus(CollectionMonitor o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((Object)((Object)o)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        CollectionMonitor castedObj = o;
        return (this.collectionID == null ? castedObj.collectionID == null : this.collectionID.equals(castedObj.collectionID)) && this.collectionStatus == castedObj.collectionStatus;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[collection=").append(this.collectionID);
        buf.append(", status=").append(this.collectionStatus);
        buf.append(", lastModifiedDate=").append(new Date(this.lastModifiedDate)).append(']');
        return buf.toString();
    }

    public void complete() {
        this.collectionStatusPrevious = (char)77;
        this.collectionStatus = (char)67;
    }

    public void startModify() {
        if (this.collectionStatus != 'M') {
            this.collectionStatusPrevious = this.collectionStatus;
            this.collectionStatus = (char)77;
        }
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public void endModify() {
        if (this.collectionStatus == 'M') {
            this.collectionStatus = this.collectionStatusPrevious == 'O' ? (char)72 : this.collectionStatusPrevious;
            this.collectionStatusPrevious = (char)77;
        }
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public void clean() {
        this.collectionStatus = (char)79;
        this.collectionStatusPrevious = (char)72;
        this.lastModifiedDate = System.currentTimeMillis();
    }
}

