/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CollectionStatus
extends Transmitable {
    private String collectionID = null;
    private char indexType = '\u0000';
    private char amType = '\u0000';
    private char state = '\u0000';
    private int insertSize = 0;
    private int updateSize = 0;
    private int deleteSize = 0;
    private int totalSize = -1;
    private int totalDeleteSize = 0;
    private long startTime = 0L;
    private long endTime = 0L;
    private long collectElapsedTime = 0L;
    private long repositoryElapsedTime = 0L;
    private long indexElapsedTime = 0L;

    public CollectionStatus() {
    }

    public CollectionStatus(String collectionID, char indexType, char amType, char state, int insertSize, int updateSize, int deleteSize, int totalSize, int totalDeleteSize, long startTime, long endTime, long collectionElapsedTime, long repositoryElapsedTime, long indexElapsedTime) {
        this.amType = amType;
        this.collectElapsedTime = collectionElapsedTime;
        this.collectionID = collectionID;
        this.deleteSize = deleteSize;
        this.endTime = endTime;
        this.indexElapsedTime = indexElapsedTime;
        this.indexType = indexType;
        this.insertSize = insertSize;
        this.repositoryElapsedTime = repositoryElapsedTime;
        this.startTime = startTime;
        this.state = state;
        this.totalDeleteSize = totalDeleteSize;
        this.totalSize = totalSize;
        this.updateSize = updateSize;
    }

    public CollectionStatus(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getCollection() {
        return this.collectionID;
    }

    public int getDeleted() {
        return this.deleteSize;
    }

    public void setDeleted(int deleteSize) {
        this.deleteSize = deleteSize;
    }

    public long getEnded() {
        return this.endTime;
    }

    public void setEnded(long endTime) {
        this.endTime = endTime;
    }

    public void setTotalIndexed(int fullSize) {
        this.totalSize = fullSize;
    }

    public int getInserted() {
        return this.insertSize;
    }

    public void setInserted(int insertSize) {
        this.insertSize = insertSize;
    }

    public long getStarted() {
        return this.startTime;
    }

    public void setStarted(long startTime) {
        this.startTime = startTime;
    }

    public int getUpdated() {
        return this.updateSize;
    }

    public void setUpdated(int updateSize) {
        this.updateSize = updateSize;
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.collectionID);
        ByteUtil.writeChar((OutputStream)out, (char)this.indexType);
        ByteUtil.writeChar((OutputStream)out, (char)this.amType);
        ByteUtil.writeChar((OutputStream)out, (char)this.state);
        ByteUtil.writeInt((OutputStream)out, (int)this.insertSize);
        ByteUtil.writeInt((OutputStream)out, (int)this.updateSize);
        ByteUtil.writeInt((OutputStream)out, (int)this.deleteSize);
        ByteUtil.writeInt((OutputStream)out, (int)this.totalSize);
        ByteUtil.writeInt((OutputStream)out, (int)this.totalDeleteSize);
        ByteUtil.writeLong((OutputStream)out, (long)this.startTime);
        ByteUtil.writeLong((OutputStream)out, (long)this.endTime);
        ByteUtil.writeLong((OutputStream)out, (long)this.collectElapsedTime);
        ByteUtil.writeLong((OutputStream)out, (long)this.repositoryElapsedTime);
        ByteUtil.writeLong((OutputStream)out, (long)this.indexElapsedTime);
    }

    public void deserialize(InputStream in) throws IOException {
        this.collectionID = ByteUtil.readString((InputStream)in);
        this.indexType = ByteUtil.readChar((InputStream)in);
        this.amType = ByteUtil.readChar((InputStream)in);
        this.state = ByteUtil.readChar((InputStream)in);
        this.insertSize = ByteUtil.readInt((InputStream)in);
        this.updateSize = ByteUtil.readInt((InputStream)in);
        this.deleteSize = ByteUtil.readInt((InputStream)in);
        this.totalSize = ByteUtil.readInt((InputStream)in);
        this.totalDeleteSize = ByteUtil.readInt((InputStream)in);
        this.startTime = ByteUtil.readLong((InputStream)in);
        this.endTime = ByteUtil.readLong((InputStream)in);
        this.collectElapsedTime = ByteUtil.readLong((InputStream)in);
        this.repositoryElapsedTime = ByteUtil.readLong((InputStream)in);
        this.indexElapsedTime = ByteUtil.readLong((InputStream)in);
    }

    public Transmitable getInstance() {
        return new CollectionStatus();
    }

    public long getCollectElipsedTime() {
        return this.getCollectElapsedTime();
    }

    public long getCollectElapsedTime() {
        return this.collectElapsedTime;
    }

    public void setCollectElipsedTime(long collectElipsedTime) {
        this.setCollectElapsedTime(collectElipsedTime);
    }

    public void setCollectElapsedTime(long collectElapsedTime) {
        this.collectElapsedTime = collectElapsedTime;
    }

    public long getIndexElipsedTime() {
        return this.getIndexElapsedTime();
    }

    public long getIndexElapsedTime() {
        return this.indexElapsedTime;
    }

    public void setIndexElipsedTime(long indexElipsedTime) {
        this.setIndexElapsedTime(indexElipsedTime);
    }

    public void setIndexElapsedTime(long indexElapsedTime) {
        this.indexElapsedTime = indexElapsedTime;
    }

    public long getRepositoryElipsedTime() {
        return this.getRepositoryElapsedTime();
    }

    public long getRepositoryElapsedTime() {
        return this.repositoryElapsedTime;
    }

    public void setRepositoryElipsedTime(long repositoryElipsedTime) {
        this.setRepositoryElapsedTime(repositoryElipsedTime);
    }

    public void setRepositoryElapsedTime(long repositoryElapsedTime) {
        this.repositoryElapsedTime = repositoryElapsedTime;
    }

    public int getTotalIndexed() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public char getIndexingType() {
        return this.indexType;
    }

    public void setIndexingType(char indexType) {
        this.indexType = indexType;
    }

    public char getStatus() {
        return this.state;
    }

    public void setStatus(char state) {
        this.state = state;
    }

    public char getExecutionType() {
        return this.amType;
    }

    public void setExecutionType(char type) {
        this.amType = type;
    }

    public int getTotalDeleteSize() {
        return this.totalDeleteSize;
    }

    public void setTotalDeleteSize(int totalDeleteSize) {
        this.totalDeleteSize = totalDeleteSize;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("==================================================").append('\n');
        buf.append("CollectionID= [" + this.collectionID + "]").append('\n');
        buf.append("Index type= [" + this.indexType + "]").append('\n');
        buf.append("Run type = [" + (this.amType == 'A' ? "Auto" : "Manual") + "]").append('\n');
        buf.append("state = [" + this.state + "]").append('\n');
        buf.append("added = [" + this.insertSize + "]").append('\n');
        buf.append("updated = [" + this.updateSize + "]").append('\n');
        buf.append("deleted = [" + this.deleteSize + "]").append('\n');
        buf.append("total documents = [" + this.totalSize + "]").append('\n');
        buf.append("total deleted documents = [" + this.totalDeleteSize + "]").append('\n');
        buf.append("active documents = [" + (this.totalSize - this.totalDeleteSize) + "]").append('\n');
        buf.append("start time = [" + this.startTime + "]").append('\n');
        buf.append("end time = [" + this.endTime + "]").append('\n');
        buf.append("collect time = [" + this.collectElapsedTime + "ms ]").append('\n');
        buf.append("repository time = [" + this.repositoryElapsedTime + "ms ]").append('\n');
        buf.append("index time = [" + this.indexElapsedTime + "]ms ").append('\n');
        buf.append("==================================================");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        CollectionStatus castedObj = (CollectionStatus)((Object)o);
        return (this.collectionID == null ? castedObj.collectionID == null : this.collectionID.equals(castedObj.collectionID)) && this.indexType == castedObj.indexType && this.amType == castedObj.amType && this.state == castedObj.state && this.insertSize == castedObj.insertSize && this.updateSize == castedObj.updateSize && this.deleteSize == castedObj.deleteSize && this.totalSize == castedObj.totalSize && this.totalDeleteSize == castedObj.totalDeleteSize && this.startTime == castedObj.startTime && this.endTime == castedObj.endTime && this.collectElapsedTime == castedObj.collectElapsedTime && this.repositoryElapsedTime == castedObj.repositoryElapsedTime && this.indexElapsedTime == castedObj.indexElapsedTime;
    }
}

