/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.database.entity.AbstractLog;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class ErrorLog
extends AbstractLog {
    private int errorID;
    private int serverGroup;
    private int serverID;
    private String serverName;
    private String serverIP;
    private Date reportedTime;
    private int level;
    private String errorMessage;
    private String serviceStack;
    private String rawStack;

    public ErrorLog() {
    }

    public ErrorLog(int errorID, int serverGroup, int serverID, String serverName, String serverIP, Date reportedTime, int level, String errorMessage, String serviceStack, String rawStack) {
        this.errorID = errorID;
        this.serverGroup = serverGroup;
        this.serverID = serverID;
        this.serverName = serverName;
        this.serverIP = serverIP;
        this.reportedTime = reportedTime;
        this.level = level;
        this.errorMessage = errorMessage;
        this.serviceStack = serviceStack;
        this.rawStack = rawStack;
    }

    public ErrorLog(int errorID, String serverName, Date reportedTime, String errorMessage) {
        this.errorID = errorID;
        this.serverName = serverName;
        this.reportedTime = reportedTime;
        this.errorMessage = errorMessage;
    }

    public ErrorLog(int errorID, int serverGroup, int serverID, String serverName, String serverIP, Date reportedTime, char confirmCode, String errorMessage, String serviceStack, String rawStack) {
        this.errorID = errorID;
        this.serverGroup = serverGroup;
        this.serverID = serverID;
        this.serverName = serverName;
        this.serverIP = serverIP;
        this.reportedTime = reportedTime;
        this.errorMessage = errorMessage;
        this.serviceStack = serviceStack;
        this.rawStack = rawStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ErrorLog castedObj = (ErrorLog)((Object)o);
        return this.errorID == castedObj.errorID && this.serverGroup == castedObj.serverGroup && this.serverID == castedObj.serverID && (this.serverName == null ? castedObj.serverName == null : this.serverName.equals(castedObj.serverName)) && (this.serverIP == null ? castedObj.serverIP == null : this.serverIP.equals(castedObj.serverIP)) && this.level == castedObj.level && (this.reportedTime == null ? castedObj.reportedTime == null : this.reportedTime.equals(castedObj.reportedTime)) && (this.errorMessage == null ? castedObj.errorMessage == null : this.errorMessage.equals(castedObj.errorMessage)) && (this.serviceStack == null ? castedObj.serviceStack == null : this.serviceStack.equals(castedObj.serviceStack)) && (this.rawStack == null ? castedObj.rawStack == null : this.rawStack.equals(castedObj.rawStack));
    }

    public int getErrorID() {
        return this.errorID;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Transmitable getInstance() {
        return new ErrorLog();
    }

    public String getRawStack() {
        return this.rawStack;
    }

    public int getLevel() {
        return this.level;
    }

    public Date getReportedTime() {
        return this.reportedTime;
    }

    public int getServerGroup() {
        return this.serverGroup;
    }

    public int getServerID() {
        return this.serverID;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServiceStack() {
        return this.serviceStack;
    }

    public int hashCode() {
        int h = 1;
        h = 31 * h + this.errorID;
        h = 31 * h + this.serverGroup;
        h = 31 * h + this.serverID;
        h = 31 * h + (this.serverName == null ? 0 : this.serverName.hashCode());
        h = 31 * h + (this.serverIP == null ? 0 : this.serverIP.hashCode());
        h = 31 * h + this.level;
        h = 31 * h + (this.reportedTime == null ? 0 : this.reportedTime.hashCode());
        h = 31 * h + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        h = 31 * h + (this.serviceStack == null ? 0 : this.serviceStack.hashCode());
        h = 31 * h + (this.rawStack == null ? 0 : this.rawStack.hashCode());
        return h;
    }

    public final void setErrorID(int errorID) {
        this.errorID = errorID;
    }

    public final void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public final void setRawStack(String rawStack) {
        this.rawStack = rawStack;
    }

    public final void setLevel(int level) {
        this.level = level;
    }

    public final void setReportedTime(Date reportedTime) {
        this.reportedTime = reportedTime;
    }

    public final void setServerGroup(int serverGroup) {
        this.serverGroup = serverGroup;
    }

    public final void setServerID(int serverID) {
        this.serverID = serverID;
    }

    public final void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public final void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public final void setServiceStack(String serviceStack) {
        this.serviceStack = serviceStack;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[errorID=");
        b.append(this.errorID);
        b.append(", serverGroup=");
        b.append(this.serverGroup);
        b.append(", serverID=");
        b.append(this.serverID);
        b.append(", serverName=");
        b.append(this.serverName);
        b.append(", serverIP=");
        b.append(this.serverIP);
        b.append(", reportedTime=");
        b.append(this.reportedTime);
        b.append(", level=");
        b.append(this.level);
        b.append(", errorMessage=");
        b.append(this.errorMessage);
        b.append(", serviceStack=");
        b.append(this.serviceStack);
        b.append(", rawStack=");
        b.append(this.rawStack);
        b.append("]");
        return b.toString();
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.errorID = ByteUtil.readInt((InputStream)in);
        this.serverGroup = ByteUtil.readInt((InputStream)in);
        this.serverID = ByteUtil.readInt((InputStream)in);
        this.serverName = ByteUtil.readString((InputStream)in);
        this.serverIP = ByteUtil.readString((InputStream)in);
        this.reportedTime = ByteUtil.readBoolean((InputStream)in) ? new Date(ByteUtil.readLong((InputStream)in)) : null;
        this.level = ByteUtil.readInt((InputStream)in);
        this.errorMessage = ByteUtil.readString((InputStream)in);
        this.serviceStack = ByteUtil.readString((InputStream)in);
        this.rawStack = ByteUtil.readString((InputStream)in);
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeInt((OutputStream)out, (int)this.errorID);
        ByteUtil.writeInt((OutputStream)out, (int)this.serverGroup);
        ByteUtil.writeInt((OutputStream)out, (int)this.serverID);
        ByteUtil.writeString((OutputStream)out, (String)this.serverName);
        ByteUtil.writeString((OutputStream)out, (String)this.serverIP);
        ByteUtil.writeBoolean((this.reportedTime != null ? 1 : 0) != 0);
        if (this.reportedTime != null) {
            ByteUtil.writeLong((OutputStream)out, (long)this.reportedTime.getTime());
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.level);
        ByteUtil.writeString((OutputStream)out, (String)this.errorMessage);
        ByteUtil.writeString((OutputStream)out, (String)this.serviceStack);
        ByteUtil.writeString((OutputStream)out, (String)this.rawStack);
    }
}

