/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.ir.common.database.entity.hotkeyword.HotKeywordFormatter;

public class HotKeyword {
    private String category;
    private String keyword;
    private int rank;
    private int beforeRank;
    private int count;
    private char fixYN;
    private long created;
    private long updated;

    public HotKeyword(String category, String keyword, int rank, int beforeRank, int count, char fixYN, long created, long updated) {
        this.category = category;
        this.keyword = HotKeywordFormatter.format(keyword);
        this.rank = rank;
        this.beforeRank = beforeRank;
        this.count = count;
        this.fixYN = fixYN;
        this.created = created;
        this.updated = updated;
    }

    public HotKeyword(String category, String keyword, int rank, int beforeRank, int count, char fixYN) {
        long currentTime = System.currentTimeMillis();
        this.category = category;
        this.keyword = HotKeywordFormatter.format(keyword);
        this.rank = rank;
        this.beforeRank = beforeRank;
        this.count = count;
        this.fixYN = fixYN;
        this.created = currentTime;
        this.updated = currentTime;
    }

    public String getCategory() {
        return this.category;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public int getRank() {
        return this.rank;
    }

    public int getBeforeRank() {
        return this.beforeRank;
    }

    public int getCount() {
        return this.count;
    }

    public char getFixYN() {
        return this.fixYN;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword.trim().toUpperCase();
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setBeforeRank(int beforeRank) {
        this.beforeRank = beforeRank;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setFixYN(char fixYN) {
        this.fixYN = fixYN;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            HotKeyword casted = (HotKeyword)obj;
            return this.category.equals(casted.category) && this.keyword.equals(casted.keyword);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(this.category).append('\t').append(this.keyword).append('\t').append(this.rank).append('\t');
        sb.append(this.beforeRank).append('\t').append(this.count).append('\t').append(this.fixYN).append(']');
        return sb.toString();
    }
}

