/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.CalendarUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.AbstractLog;
import com.diquest.ir.common.database.handler.IndexLogDB;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class IndexLog
extends AbstractLog {
    private static final Date DFLT_TIME = DateUtil.getDefaultDate();
    private String collection;
    private char indexingType;
    private char executionType;
    private char status;
    private int insertCollected;
    private int updateCollected;
    private int deleteCollected;
    private int inserted;
    private int updated;
    private int deleted;
    private int serviceable;
    private int totalIndexed;
    private Date started = DFLT_TIME;
    private Date ended = DFLT_TIME;
    private Date collectionStarted = DFLT_TIME;
    private Date collectionEnded = DFLT_TIME;
    private Date repositoryStarted = DFLT_TIME;
    private Date repositoryEnded = DFLT_TIME;
    private Date indexingStarted = DFLT_TIME;
    private Date indexingEnded = DFLT_TIME;
    private long nanoTime = 0L;

    public long getNanoTime() {
        return this.nanoTime;
    }

    public void setNanoTime(long nanoTime) {
        this.nanoTime = nanoTime;
    }

    public IndexLog() {
    }

    public IndexLog(String collection) {
        this.collection = collection;
    }

    public IndexLog(String collection, long started, long nanoTime, char indexingType, char executionType, char status) {
        this(collection);
        this.setStarted(new Date(started));
        this.setNanoTime(nanoTime);
        this.setIndexingType(indexingType);
        this.setExecutionType(executionType);
        this.setStatus(status);
    }

    public void validate() {
        if (this.collection == null || this.collection.length() == 0) {
            throw new IllegalArgumentException("An empty or null collection is not allowed.");
        }
        if (this.serviceable < 0) {
            throw new IllegalArgumentException("The number of documents cannot be negative.");
        }
        if (this.totalIndexed < 0) {
            throw new IllegalArgumentException("The number of documents cannot be negative.");
        }
        if (this.totalIndexed < this.serviceable) {
            throw new IllegalArgumentException("The number of serviceable documents cannot be larger than of total indexed documents.");
        }
        if (IndexLogDB.Status.isFinished(this.status)) {
            if (this.insertCollected < 0 || this.updateCollected < 0 || this.deleteCollected < 0) {
                throw new IllegalArgumentException("The number of collected documents cannot be negative.");
            }
            if (this.inserted < 0 || this.updated < 0 || this.deleted < 0) {
                throw new IllegalArgumentException("The number of applied documents cannot be negative.");
            }
        }
        IndexLogDB.IndexingType.validate(this.indexingType);
        IndexLogDB.ExecutionType.validate(this.executionType);
        IndexLogDB.Status.validate(this.status);
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.setCollection(ByteUtil.readString((InputStream)in));
        this.setIndexingType(ByteUtil.readChar((InputStream)in));
        this.setExecutionType(ByteUtil.readChar((InputStream)in));
        this.setStatus(ByteUtil.readChar((InputStream)in));
        this.setInsertCollected(ByteUtil.readInt((InputStream)in));
        this.setUpdateCollected(ByteUtil.readInt((InputStream)in));
        this.setDeleteCollected(ByteUtil.readInt((InputStream)in));
        this.setInserted(ByteUtil.readInt((InputStream)in));
        this.setUpdated(ByteUtil.readInt((InputStream)in));
        this.setDeleted(ByteUtil.readInt((InputStream)in));
        this.setServiceable(ByteUtil.readInt((InputStream)in));
        this.setTotalIndexed(ByteUtil.readInt((InputStream)in));
        this.setStarted(new Date(ByteUtil.readLong((InputStream)in)));
        this.setEnded(new Date(ByteUtil.readLong((InputStream)in)));
        this.setCollectionStarted(new Date(ByteUtil.readLong((InputStream)in)));
        this.setCollectionEnded(new Date(ByteUtil.readLong((InputStream)in)));
        this.setRepositoryStarted(new Date(ByteUtil.readLong((InputStream)in)));
        this.setRepositoryEnded(new Date(ByteUtil.readLong((InputStream)in)));
        this.setIndexingStarted(new Date(ByteUtil.readLong((InputStream)in)));
        this.setIndexingEnded(new Date(ByteUtil.readLong((InputStream)in)));
        this.setNanoTime(ByteUtil.readLong((InputStream)in));
    }

    public final String getCollection() {
        return this.collection;
    }

    public final String getCollectionId() {
        return this.collection;
    }

    public final Date getCollectionEnded() {
        return this.collectionEnded;
    }

    public final Date getCollectionStarted() {
        return this.collectionStarted;
    }

    public final int getDeleteCollected() {
        return this.deleteCollected;
    }

    public final int getDeleted() {
        return this.deleted;
    }

    public final Date getEnded() {
        return this.ended;
    }

    public final char getExecutionType() {
        return this.executionType;
    }

    public final Date getIndexingEnded() {
        return this.indexingEnded;
    }

    public final Date getIndexingStarted() {
        return this.indexingStarted;
    }

    public final char getIndexingType() {
        return this.indexingType;
    }

    public final int getInsertCollected() {
        return this.insertCollected;
    }

    public final int getInserted() {
        return this.inserted;
    }

    public Transmitable getInstance() {
        return new IndexLog();
    }

    public final Date getRepositoryEnded() {
        return this.repositoryEnded;
    }

    public final Date getRepositoryStarted() {
        return this.repositoryStarted;
    }

    public final int getServiceable() {
        return this.serviceable;
    }

    public final Date getStarted() {
        return this.started;
    }

    public final char getStatus() {
        return this.status;
    }

    public final Date getTime() {
        return this.started;
    }

    public final int getTotalIndexed() {
        return this.totalIndexed;
    }

    public final int getUpdateCollected() {
        return this.updateCollected;
    }

    public final int getUpdated() {
        return this.updated;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeString((OutputStream)out, (String)this.collection);
        ByteUtil.writeChar((OutputStream)out, (char)this.indexingType);
        ByteUtil.writeChar((OutputStream)out, (char)this.executionType);
        ByteUtil.writeChar((OutputStream)out, (char)this.status);
        ByteUtil.writeInt((OutputStream)out, (int)this.insertCollected);
        ByteUtil.writeInt((OutputStream)out, (int)this.updateCollected);
        ByteUtil.writeInt((OutputStream)out, (int)this.deleteCollected);
        ByteUtil.writeInt((OutputStream)out, (int)this.inserted);
        ByteUtil.writeInt((OutputStream)out, (int)this.updated);
        ByteUtil.writeInt((OutputStream)out, (int)this.deleted);
        ByteUtil.writeInt((OutputStream)out, (int)this.serviceable);
        ByteUtil.writeInt((OutputStream)out, (int)this.totalIndexed);
        ByteUtil.writeLong((OutputStream)out, (long)this.started.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.ended.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.collectionStarted.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.collectionEnded.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.repositoryStarted.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.repositoryEnded.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.indexingStarted.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.indexingEnded.getTime());
        ByteUtil.writeLong((OutputStream)out, (long)this.nanoTime);
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setIndexingType(char indexingType) {
        this.indexingType = indexingType;
    }

    public void setExecutionType(char executionType) {
        this.executionType = executionType;
    }

    public void setStatus(char status) {
        this.status = status;
    }

    public void setInsertCollected(int insertCollected) {
        this.insertCollected = insertCollected;
    }

    public void setUpdateCollected(int updateCollected) {
        this.updateCollected = updateCollected;
    }

    public void setDeleteCollected(int deleteCollected) {
        this.deleteCollected = deleteCollected;
    }

    public void setInserted(int inserted) {
        this.inserted = inserted;
    }

    public void setUpdated(int updated) {
        this.updated = updated;
    }

    public void setDeleted(int deleted) {
        this.deleted = deleted;
    }

    public void setServiceable(int serviceable) {
        this.serviceable = serviceable;
    }

    public void setTotalIndexed(int totalIndexed) {
        this.totalIndexed = totalIndexed;
    }

    public void setStarted(Date started) {
        this.started = started;
    }

    public void setEnded(Date ended) {
        this.ended = ended;
    }

    public void setCollectionStarted(Date collectionStarted) {
        this.collectionStarted = collectionStarted;
    }

    public void setCollectionEnded(Date collectionEnded) {
        this.collectionEnded = collectionEnded;
    }

    public void setRepositoryStarted(Date repositoryStarted) {
        this.repositoryStarted = repositoryStarted;
    }

    public void setRepositoryEnded(Date repositoryEnded) {
        this.repositoryEnded = repositoryEnded;
    }

    public void setIndexingStarted(Date indexingStarted) {
        this.indexingStarted = indexingStarted;
    }

    public void setIndexingEnded(Date indexingEnded) {
        this.indexingEnded = indexingEnded;
    }

    public void setStarted(long started) {
        this.setStarted(new Date(started));
    }

    public void setEnded(long ended) {
        this.setEnded(new Date(ended));
    }

    public void setCollectionStarted(long collectionStarted) {
        this.setCollectionStarted(new Date(collectionStarted));
    }

    public void setCollectionEnded(long collectionEnded) {
        this.setCollectionEnded(new Date(collectionEnded));
    }

    public void setRepositoryStarted(long repositoryStarted) {
        this.setRepositoryStarted(new Date(repositoryStarted));
    }

    public void setRepositoryEnded(long repositoryEnded) {
        this.setRepositoryEnded(new Date(repositoryEnded));
    }

    public void setIndexingStarted(long indexingStarted) {
        this.setIndexingStarted(new Date(indexingStarted));
    }

    public void setIndexingEnded(long indexingEnded) {
        this.setIndexingEnded(new Date(indexingEnded));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(512);
        String string = super.toString();
        buf.append("[");
        if (string.length() > 0) {
            buf.append(string);
            buf.append(", ");
        }
        buf.append("collection=");
        buf.append(this.collection);
        buf.append(", ");
        buf.append("indexingType=");
        buf.append(this.indexingType);
        buf.append(", ");
        buf.append("executionType=");
        buf.append(this.executionType);
        buf.append(", ");
        buf.append("status=");
        buf.append(this.status);
        buf.append(", ");
        buf.append("insertCollected=");
        buf.append(this.insertCollected);
        buf.append(", ");
        buf.append("updateCollected=");
        buf.append(this.updateCollected);
        buf.append(", ");
        buf.append("deleteCollected=");
        buf.append(this.deleteCollected);
        buf.append(", ");
        buf.append("inserted=");
        buf.append(this.inserted);
        buf.append(", ");
        buf.append("updated=");
        buf.append(this.updated);
        buf.append(", ");
        buf.append("deleted=");
        buf.append(this.deleted);
        buf.append(", ");
        buf.append("serviceable=");
        buf.append(this.serviceable);
        buf.append(", ");
        buf.append("totalIndexed=");
        buf.append(this.totalIndexed);
        buf.append(", ");
        buf.append("started=");
        buf.append((Object)this.started);
        buf.append(", ");
        buf.append("ended=");
        buf.append((Object)this.ended);
        buf.append(", ");
        buf.append("collectionStarted=");
        buf.append((Object)this.collectionStarted);
        buf.append(", ");
        buf.append("collectionEnded=");
        buf.append((Object)this.collectionEnded);
        buf.append(", ");
        buf.append("repositoryStarted=");
        buf.append((Object)this.repositoryStarted);
        buf.append(", ");
        buf.append("repositoryEnded=");
        buf.append((Object)this.repositoryEnded);
        buf.append(", ");
        buf.append("indexingStarted=");
        buf.append((Object)this.indexingStarted);
        buf.append(", ");
        buf.append("indexingEnded=");
        buf.append((Object)this.indexingEnded);
        buf.append(", ");
        buf.append("nanoTime=");
        buf.append(this.nanoTime);
        buf.append("]");
        return buf.toString();
    }

    public String toStringSmart() {
        StringBuilder buf = new StringBuilder(512);
        String string = super.toString();
        buf.append("[");
        if (string.length() > 0) {
            buf.append(string);
            buf.append(", ");
        }
        buf.append("collection=");
        buf.append(this.collection);
        buf.append(", ");
        buf.append("indexingType=");
        buf.append(this.indexingType);
        buf.append(", ");
        buf.append("executionType=");
        buf.append(this.executionType);
        buf.append(", ");
        buf.append("status=");
        buf.append(this.status);
        buf.append(", ");
        buf.append("insertCollected=");
        buf.append(this.insertCollected);
        buf.append(", ");
        buf.append("updateCollected=");
        buf.append(this.updateCollected);
        buf.append(", ");
        buf.append("deleteCollected=");
        buf.append(this.deleteCollected);
        buf.append(", ");
        buf.append("inserted=");
        buf.append(this.inserted);
        buf.append(", ");
        buf.append("updated=");
        buf.append(this.updated);
        buf.append(", ");
        buf.append("deleted=");
        buf.append(this.deleted);
        buf.append(", ");
        buf.append("serviceable=");
        buf.append(this.serviceable);
        buf.append(", ");
        buf.append("totalIndexed=");
        buf.append(this.totalIndexed);
        buf.append(", ");
        buf.append("started=");
        buf.append(CalendarUtil.formatISO8601((long)this.started.getTime()));
        buf.append(", ");
        buf.append("ended=");
        buf.append(CalendarUtil.formatISO8601((long)this.ended.getTime()));
        buf.append(", ");
        buf.append("collectionStarted=");
        buf.append(CalendarUtil.formatISO8601((long)this.collectionStarted.getTime()));
        buf.append(", ");
        buf.append("collectionEnded=");
        buf.append(CalendarUtil.formatISO8601((long)this.collectionEnded.getTime()));
        buf.append(", ");
        buf.append("repositoryStarted=");
        buf.append(CalendarUtil.formatISO8601((long)this.repositoryStarted.getTime()));
        buf.append(", ");
        buf.append("repositoryEnded=");
        buf.append(CalendarUtil.formatISO8601((long)this.repositoryEnded.getTime()));
        buf.append(", ");
        buf.append("indexingStarted=");
        buf.append(CalendarUtil.formatISO8601((long)this.indexingStarted.getTime()));
        buf.append(", ");
        buf.append("indexingEnded=");
        buf.append(CalendarUtil.formatISO8601((long)this.indexingEnded.getTime()));
        buf.append(", ");
        buf.append("nanoTime=");
        buf.append(this.nanoTime);
        buf.append("]");
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
        result = 31 * result + (this.collectionEnded == null ? 0 : this.collectionEnded.hashCode());
        result = 31 * result + (this.collectionStarted == null ? 0 : this.collectionStarted.hashCode());
        result = 31 * result + this.deleteCollected;
        result = 31 * result + this.deleted;
        result = 31 * result + (this.ended == null ? 0 : this.ended.hashCode());
        result = 31 * result + this.executionType;
        result = 31 * result + (this.indexingEnded == null ? 0 : this.indexingEnded.hashCode());
        result = 31 * result + (this.indexingStarted == null ? 0 : this.indexingStarted.hashCode());
        result = 31 * result + this.indexingType;
        result = 31 * result + this.insertCollected;
        result = 31 * result + this.inserted;
        result = 31 * result + (int)(this.nanoTime ^ this.nanoTime >>> 32);
        result = 31 * result + (this.repositoryEnded == null ? 0 : this.repositoryEnded.hashCode());
        result = 31 * result + (this.repositoryStarted == null ? 0 : this.repositoryStarted.hashCode());
        result = 31 * result + this.serviceable;
        result = 31 * result + (this.started == null ? 0 : this.started.hashCode());
        result = 31 * result + this.status;
        result = 31 * result + this.totalIndexed;
        result = 31 * result + this.updateCollected;
        result = 31 * result + this.updated;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IndexLog other = (IndexLog)((Object)obj);
        if (this.collection == null ? other.collection != null : !this.collection.equals(other.collection)) {
            return false;
        }
        if (this.collectionEnded == null ? other.collectionEnded != null : !this.collectionEnded.equals(other.collectionEnded)) {
            return false;
        }
        if (this.collectionStarted == null ? other.collectionStarted != null : !this.collectionStarted.equals(other.collectionStarted)) {
            return false;
        }
        if (this.deleteCollected != other.deleteCollected) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.ended == null ? other.ended != null : !this.ended.equals(other.ended)) {
            return false;
        }
        if (this.executionType != other.executionType) {
            return false;
        }
        if (this.indexingEnded == null ? other.indexingEnded != null : !this.indexingEnded.equals(other.indexingEnded)) {
            return false;
        }
        if (this.indexingStarted == null ? other.indexingStarted != null : !this.indexingStarted.equals(other.indexingStarted)) {
            return false;
        }
        if (this.indexingType != other.indexingType) {
            return false;
        }
        if (this.insertCollected != other.insertCollected) {
            return false;
        }
        if (this.inserted != other.inserted) {
            return false;
        }
        if (this.nanoTime != other.nanoTime) {
            return false;
        }
        if (this.repositoryEnded == null ? other.repositoryEnded != null : !this.repositoryEnded.equals(other.repositoryEnded)) {
            return false;
        }
        if (this.repositoryStarted == null ? other.repositoryStarted != null : !this.repositoryStarted.equals(other.repositoryStarted)) {
            return false;
        }
        if (this.serviceable != other.serviceable) {
            return false;
        }
        if (this.started == null ? other.started != null : !this.started.equals(other.started)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.totalIndexed != other.totalIndexed) {
            return false;
        }
        if (this.updateCollected != other.updateCollected) {
            return false;
        }
        return this.updated == other.updated;
    }

    public IndexLog fail() {
        this.setEnded(System.currentTimeMillis());
        this.setStatus('F');
        return this;
    }

    public IndexLog success() {
        this.setEnded(System.currentTimeMillis());
        this.setStatus('S');
        return this;
    }
}

