/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.TimeUtil;
import com.diquest.ir.util.common.DateUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class IndexingJob {
    private int jobID;
    private char enable;
    private char jobType;
    private String collectionID;
    private long indexCycle;
    private char startDateType;
    private Date startDate;
    private Date created;
    private Date lastUpdated;
    private String executor;
    private char limitEnable;
    private long limitStart;
    private long limitEnd;

    public IndexingJob(int jobID, char enable, char jobType, String collectionID, long indexCycle, char startDateType, long startDate, Date created, Date lastUpdated, String executor, char limitEnable, long limitStart, long limitEnd) {
        throw new UnsupportedOperationException();
    }

    public IndexingJob(int jobID, char enable, char jobType, String collectionID, long indexCycle, Date startDate, Date created, Date lastUpdated, String executor, char limitEnable, long limitStart, long limitEnd) {
        this.jobID = jobID;
        this.enable = enable;
        this.jobType = jobType;
        this.collectionID = collectionID;
        this.indexCycle = indexCycle;
        this.startDate = startDate;
        this.created = created;
        this.lastUpdated = lastUpdated;
        this.executor = executor;
        this.limitEnable = limitEnable;
        this.limitStart = limitStart;
        this.limitEnd = limitEnd;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public Date getCreated() {
        return this.created;
    }

    public char getEnable() {
        return this.enable;
    }

    public boolean isEnable() {
        return this.enable == 'A';
    }

    public String getExecutor() {
        return this.executor;
    }

    public long getIndexCycle() {
        return this.indexCycle;
    }

    public int getJobID() {
        return this.jobID;
    }

    public char getJobType() {
        return this.jobType;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public char getStartDateType() {
        return this.startDateType;
    }

    public boolean isLimitEnable() {
        return this.limitEnable == 'A';
    }

    public char getLimitEnable() {
        return this.limitEnable;
    }

    public long getLimitStart() {
        return this.limitStart;
    }

    public long getLimitEnd() {
        return this.limitEnd;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collectionID == null ? 0 : this.collectionID.hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + this.enable;
        result = 31 * result + (this.executor == null ? 0 : this.executor.hashCode());
        result = 31 * result + (int)(this.indexCycle ^ this.indexCycle >>> 32);
        result = 31 * result + this.jobID;
        result = 31 * result + this.jobType;
        result = 31 * result + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        result = 31 * result + this.limitEnable;
        result = 31 * result + (int)(this.limitEnd ^ this.limitEnd >>> 32);
        result = 31 * result + (int)(this.limitStart ^ this.limitStart >>> 32);
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexingJob other = (IndexingJob)obj;
        if (this.collectionID == null ? other.collectionID != null : !this.collectionID.equals(other.collectionID)) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.enable != other.enable) {
            return false;
        }
        if (this.executor == null ? other.executor != null : !this.executor.equals(other.executor)) {
            return false;
        }
        if (this.indexCycle != other.indexCycle) {
            return false;
        }
        if (this.jobID != other.jobID) {
            return false;
        }
        if (this.jobType != other.jobType) {
            return false;
        }
        if (this.lastUpdated == null ? other.lastUpdated != null : !this.lastUpdated.equals(other.lastUpdated)) {
            return false;
        }
        if (this.limitEnable != other.limitEnable) {
            return false;
        }
        if (this.limitEnd != other.limitEnd) {
            return false;
        }
        if (this.limitStart != other.limitStart) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[jobID=");
        buffer.append(this.jobID);
        buffer.append(", enable=");
        buffer.append(this.enable);
        buffer.append(", jobType=");
        buffer.append(this.jobType);
        buffer.append(", collectionID=");
        buffer.append(this.collectionID);
        buffer.append(", indexCycle=");
        buffer.append(this.indexCycle);
        buffer.append(", startDate=");
        buffer.append(this.startDate);
        buffer.append(", created=");
        buffer.append(this.created);
        buffer.append(", lastUpdated=");
        buffer.append(this.lastUpdated);
        buffer.append(", executor=");
        buffer.append(this.executor);
        buffer.append(", limitEnable=");
        buffer.append(this.limitEnable);
        buffer.append(", limitStart=");
        buffer.append(this.limitStart);
        buffer.append(", limitEnd=");
        buffer.append(this.limitEnd);
        buffer.append("]");
        return buffer.toString();
    }

    public String toStringFormatted() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[jobID=");
        buffer.append(this.jobID);
        buffer.append(", enable=");
        buffer.append(this.enable);
        buffer.append(", jobType=");
        buffer.append(this.jobType);
        buffer.append(", collectionID=");
        buffer.append(this.collectionID);
        buffer.append(", indexCycle=");
        buffer.append(TimeUtil.getSimplifiedTimeString((long)this.indexCycle));
        buffer.append(", startDate=");
        buffer.append(this.startDate.toString());
        buffer.append(", created=");
        buffer.append(this.created);
        buffer.append(", lastUpdated=");
        buffer.append(this.lastUpdated);
        buffer.append(", executor=");
        buffer.append(this.executor);
        buffer.append(", limitEnable=");
        buffer.append(this.limitEnable);
        buffer.append(", limitStart=");
        buffer.append(TimeUtil.getSimplifiedTimeString((long)this.limitStart));
        buffer.append(", limitEnd=");
        buffer.append(TimeUtil.getSimplifiedTimeString((long)this.limitEnd));
        buffer.append("]");
        return buffer.toString();
    }

    public long nextScheduledTime() {
        return this.nextScheduledTime(this.getStartDate().getTime());
    }

    public long nextScheduledTime(long prev) {
        long base = System.currentTimeMillis();
        return this.nextScheduledTime(prev, base);
    }

    public long nextScheduledTime(long prev, long base) {
        long cycle = this.getIndexCycle();
        long start = this.getLimitStart();
        long end = this.getLimitEnd();
        long next = IndexingJob.adjust(prev, base, cycle);
        if (this.isLimitEnable()) {
            HashSet visited = new HashSet();
            while (IndexingJob.isLimited(next, start, end)) {
                if (IndexingJob.isAlwaysLimited(next, visited)) {
                    next = Long.MAX_VALUE;
                    break;
                }
                next = base > DateUtil.getDayStart((long)next) ? IndexingJob.adjust(next, end + (end < start ? 86400000L : 0L) + DateUtil.getDayStart((long)next), cycle) : IndexingJob.adjust(next, end + DateUtil.getDayStart((long)next), cycle);
            }
            visited.clear();
        }
        return next;
    }

    private static boolean isAlwaysLimited(long nextScheduledTime, Set visited) {
        long next = nextScheduledTime - DateUtil.getDayStart((long)nextScheduledTime);
        return !visited.add(new Long(next));
    }

    private static boolean isLimited(long nextScheduledTime, long start, long end) {
        long next = nextScheduledTime - DateUtil.getDayStart((long)nextScheduledTime);
        if (start < end) {
            return start <= next && next < end;
        }
        if (end < start) {
            return start <= next || next < end;
        }
        return false;
    }

    private static long adjust(long nextScheduledTime, long base, long cycle) {
        if (nextScheduledTime < 0L || cycle < 0L || base < 0L) {
            return Long.MAX_VALUE;
        }
        if (base > nextScheduledTime) {
            long remain = base - nextScheduledTime;
            nextScheduledTime += cycle * (remain / cycle + (long)(remain % cycle != 0L ? 1 : 0));
        }
        if (nextScheduledTime < 0L) {
            return Long.MAX_VALUE;
        }
        return nextScheduledTime;
    }
}

