/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.database.entity.AbstractLog;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class JobLog
extends AbstractLog {
    private int jobID;
    private String jobDesc;
    private char jobStatus;
    private char enable;
    private byte[] requestMessage;
    private char responseCode;
    private String responseMessage;
    private Date created;
    private Date lastUpdated;
    private String executor;

    public JobLog() {
    }

    public JobLog(int jobID, String jobDesc, char jobStatus, char enable, byte[] requestMessage, char responseCode, String responseMessage, Date created, Date lastUpdated, String executor) {
        this.jobID = jobID;
        this.jobDesc = jobDesc;
        this.jobStatus = jobStatus;
        this.enable = enable;
        this.requestMessage = requestMessage;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.created = created;
        this.lastUpdated = lastUpdated;
        this.executor = executor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        JobLog castedObj = (JobLog)((Object)o);
        return super.equals(o) && this.jobID == castedObj.jobID && (this.jobDesc == null ? castedObj.jobDesc == null : this.jobDesc.equals(castedObj.jobDesc)) && this.jobStatus == castedObj.jobStatus && this.enable == castedObj.enable && Arrays.equals(this.requestMessage, castedObj.requestMessage) && this.responseCode == castedObj.responseCode && (this.responseMessage == null ? castedObj.responseMessage == null : this.responseMessage.equals(castedObj.responseMessage)) && (this.created == null ? castedObj.created == null : this.created.equals(castedObj.created)) && (this.lastUpdated == null ? castedObj.lastUpdated == null : this.lastUpdated.equals(castedObj.lastUpdated)) && (this.executor == null ? castedObj.executor == null : this.executor.equals(castedObj.executor));
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreated(String delimiter) {
        return this.getFormattedDate(delimiter, ":", this.created);
    }

    public final char getEnable() {
        return this.enable;
    }

    public String getExecuter() {
        return this.getExecutor();
    }

    public final String getExecutor() {
        return this.executor;
    }

    public String getJobDesc() {
        return this.jobDesc;
    }

    public int getJobID() {
        return this.jobID;
    }

    public char getJobStatus() {
        return this.jobStatus;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLastUpdated(String delimiter) {
        return this.getFormattedDate(delimiter, ":", this.lastUpdated);
    }

    public byte[] getRequestMessage() {
        return this.requestMessage;
    }

    public char getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public int hashCode() {
        int h = 1;
        h = 31 * h + this.jobID;
        h = 31 * h + (this.jobDesc == null ? 0 : this.jobDesc.hashCode());
        h = 31 * h + this.jobStatus;
        h = 31 * h + this.enable;
        int i0 = 0;
        while (this.requestMessage != null && i0 < this.requestMessage.length) {
            h = 31 * h + this.requestMessage[i0];
            ++i0;
        }
        h = 31 * h + this.responseCode;
        h = 31 * h + (this.responseMessage == null ? 0 : this.responseMessage.hashCode());
        h = 31 * h + (this.created == null ? 0 : this.created.hashCode());
        h = 31 * h + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        h = 31 * h + (this.executor == null ? 0 : this.executor.hashCode());
        return h;
    }

    public char isEnable() {
        return this.enable;
    }

    public final void setCreated(Date created) {
        this.created = created;
    }

    public final void setEnable(char enable) {
        this.enable = enable;
    }

    public final void setExecutor(String executor) {
        this.executor = executor;
    }

    public final void setJobDesc(String jobDesc) {
        this.jobDesc = jobDesc;
    }

    public final void setJobID(int jobID) {
        this.jobID = jobID;
    }

    public final void setJobStatus(char jobStatus) {
        this.jobStatus = jobStatus;
    }

    public final void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public final void setRequestMessage(byte[] requestMessage) {
        this.requestMessage = requestMessage;
    }

    public final void setResponseCode(char responseCode) {
        this.responseCode = responseCode;
    }

    public final void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[Job:");
        b.append(" jobID: ");
        b.append(this.jobID);
        b.append(" jobDesc: ");
        b.append(this.jobDesc);
        b.append(" jobStatus: ");
        b.append(this.jobStatus);
        b.append(" enable: ");
        b.append(this.enable);
        b.append(" { ");
        int i0 = 0;
        while (this.requestMessage != null && i0 < this.requestMessage.length) {
            b.append(" requestMessage[" + i0 + "]: ");
            b.append(this.requestMessage[i0]);
            ++i0;
        }
        b.append(" } ");
        b.append(" responseCode: ");
        b.append(this.responseCode);
        b.append(" responseMessage: ");
        b.append(this.responseMessage);
        b.append(" created: ");
        b.append(this.created);
        b.append(" lastUpdated: ");
        b.append(this.lastUpdated);
        b.append(" executor: ");
        b.append(this.executor);
        b.append("]");
        return b.toString();
    }

    private String getFormattedDate(String dateDelimeter, String timeDelimeter, Date date) {
        String result = new SimpleDateFormat("yyyy" + dateDelimeter + "MM" + dateDelimeter + "dd").format(date);
        result = String.valueOf(result) + "<BR>" + new SimpleDateFormat("HH" + timeDelimeter + "mm" + timeDelimeter + "ss").format(date);
        return result;
    }

    public Transmitable getInstance() {
        return new JobLog();
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeInt((OutputStream)out, (int)this.jobID);
        ByteUtil.writeString((OutputStream)out, (String)this.jobDesc);
        ByteUtil.writeChar((OutputStream)out, (char)this.jobStatus);
        ByteUtil.writeChar((OutputStream)out, (char)this.enable);
        ByteUtil.writeBytes((OutputStream)out, (byte[])this.requestMessage);
        ByteUtil.writeChar((OutputStream)out, (char)this.responseCode);
        ByteUtil.writeString((OutputStream)out, (String)this.responseMessage);
        ByteUtil.writeBoolean((this.created != null ? 1 : 0) != 0);
        if (this.created != null) {
            ByteUtil.writeLong((OutputStream)out, (long)this.created.getTime());
        }
        ByteUtil.writeBoolean((this.lastUpdated != null ? 1 : 0) != 0);
        if (this.lastUpdated != null) {
            ByteUtil.writeLong((OutputStream)out, (long)this.lastUpdated.getTime());
        }
        ByteUtil.writeString((OutputStream)out, (String)this.executor);
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.jobID = ByteUtil.readInt((InputStream)in);
        this.jobDesc = ByteUtil.readString((InputStream)in);
        this.jobStatus = ByteUtil.readChar((InputStream)in);
        this.enable = ByteUtil.readChar((InputStream)in);
        this.requestMessage = ByteUtil.readBytes((InputStream)in);
        this.responseCode = ByteUtil.readChar((InputStream)in);
        this.responseMessage = ByteUtil.readString((InputStream)in);
        this.created = ByteUtil.readBoolean((InputStream)in) ? new Date(ByteUtil.readLong((InputStream)in)) : null;
        this.lastUpdated = ByteUtil.readBoolean((InputStream)in) ? new Date(ByteUtil.readLong((InputStream)in)) : null;
        this.executor = ByteUtil.readString((InputStream)in);
    }
}

