/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.AbstractLog;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class ServerLog
extends AbstractLog {
    private String server;
    private double denial;
    private double errors;
    private double spaceUsed;
    private double spaceRemain;
    private double cpuUsage;
    private double memoryUsed;
    private double spaceUsedByIr;
    private double cpuUsageByIr;
    private double memoryMaxByIr;
    private double memoryTotalByIr;
    private double memoryUsedByIr;
    private double connection;
    private int day;
    private int hour;
    private int minute;
    private Date registered;

    public static ServerLog max(ServerLog[] logs) {
        if (logs.length == 0) {
            return new ServerLog();
        }
        ServerLog serverLog = new ServerLog(logs[0]);
        int i = 1;
        while (i < logs.length) {
            serverLog.setDenial(Math.max(serverLog.getDenial(), logs[i].getDenial()));
            serverLog.setErrors(Math.max(serverLog.getErrors(), logs[i].getErrors()));
            serverLog.setSpaceUsed(Math.max(serverLog.getSpaceUsed(), logs[i].getSpaceUsed()));
            serverLog.setSpaceRemain(Math.max(serverLog.getSpaceRemain(), logs[i].getSpaceRemain()));
            serverLog.setCpuUsage(Math.max(serverLog.getCpuUsage(), logs[i].getCpuUsage()));
            serverLog.setMemoryUsed(Math.max(serverLog.getMemoryUsed(), logs[i].getMemoryUsed()));
            serverLog.setSpaceUsedByIr(Math.max(serverLog.getSpaceUsedByIr(), logs[i].getSpaceUsedByIr()));
            serverLog.setCpuUsageByIr(Math.max(serverLog.getCpuUsageByIr(), logs[i].getCpuUsageByIr()));
            serverLog.setMemoryMaxByIr(Math.max(serverLog.getMemoryMaxByIr(), logs[i].getMemoryMaxByIr()));
            serverLog.setMemoryTotalByIr(Math.max(serverLog.getMemoryTotalByIr(), logs[i].getMemoryTotalByIr()));
            serverLog.setMemoryUsedByIr(Math.max(serverLog.getMemoryUsedByIr(), logs[i].getMemoryUsedByIr()));
            serverLog.setConnection(Math.max(serverLog.getConnection(), logs[i].getConnection()));
            ++i;
        }
        return serverLog;
    }

    public static ServerLog mergeAuto(ServerLog[] logs) {
        ServerLog serverLog = new ServerLog();
        int i = 0;
        while (i < logs.length) {
            serverLog.setMemoryMaxByIr(Math.max(serverLog.getMemoryMaxByIr(), logs[i].getMemoryMaxByIr()));
            ++i;
        }
        i = 0;
        while (i < logs.length) {
            serverLog.setDenial(serverLog.getDenial() + logs[i].getDenial());
            serverLog.setErrors(serverLog.getErrors() + logs[i].getErrors());
            ++i;
        }
        i = 0;
        while (i < logs.length) {
            serverLog.setSpaceUsed(serverLog.getSpaceUsed() + logs[i].getSpaceUsed());
            serverLog.setSpaceRemain(serverLog.getSpaceRemain() + logs[i].getSpaceRemain());
            serverLog.setCpuUsage(serverLog.getCpuUsage() + logs[i].getCpuUsage());
            serverLog.setSpaceUsedByIr(serverLog.getSpaceUsedByIr() + logs[i].getSpaceUsedByIr());
            serverLog.setCpuUsageByIr(serverLog.getCpuUsageByIr() + logs[i].getCpuUsageByIr());
            serverLog.setMemoryUsed(serverLog.getMemoryUsed() + logs[i].getMemoryUsed());
            serverLog.setMemoryTotalByIr(serverLog.getMemoryTotalByIr() + logs[i].getMemoryTotalByIr());
            serverLog.setMemoryUsedByIr(serverLog.getMemoryUsedByIr() + logs[i].getMemoryUsedByIr());
            serverLog.setConnection(serverLog.getConnection() + logs[i].getConnection());
            ++i;
        }
        if (logs.length > 0) {
            serverLog.setSpaceUsed(serverLog.getSpaceUsed() / (double)logs.length);
            serverLog.setSpaceRemain(serverLog.getSpaceRemain() / (double)logs.length);
            serverLog.setCpuUsage(serverLog.getCpuUsage() / (double)logs.length);
            serverLog.setSpaceUsedByIr(serverLog.getSpaceUsedByIr() / (double)logs.length);
            serverLog.setCpuUsageByIr(serverLog.getCpuUsageByIr() / (double)logs.length);
            serverLog.setMemoryUsed(serverLog.getMemoryUsed() / (double)logs.length);
            serverLog.setMemoryTotalByIr(serverLog.getMemoryTotalByIr() / (double)logs.length);
            serverLog.setMemoryUsedByIr(serverLog.getMemoryUsedByIr() / (double)logs.length);
            serverLog.setConnection(serverLog.getConnection() / (double)logs.length);
        }
        return serverLog;
    }

    public static ServerLog min(ServerLog[] logs) {
        if (logs.length == 0) {
            return new ServerLog();
        }
        ServerLog serverLog = new ServerLog(logs[0]);
        int i = 1;
        while (i < logs.length) {
            serverLog.setDenial(Math.min(serverLog.getDenial(), logs[i].getDenial()));
            serverLog.setErrors(Math.min(serverLog.getErrors(), logs[i].getErrors()));
            serverLog.setSpaceUsed(Math.min(serverLog.getSpaceUsed(), logs[i].getSpaceUsed()));
            serverLog.setSpaceRemain(Math.min(serverLog.getSpaceRemain(), logs[i].getSpaceRemain()));
            serverLog.setCpuUsage(Math.min(serverLog.getCpuUsage(), logs[i].getCpuUsage()));
            serverLog.setMemoryUsed(Math.min(serverLog.getMemoryUsed(), logs[i].getMemoryUsed()));
            serverLog.setSpaceUsedByIr(Math.min(serverLog.getSpaceUsedByIr(), logs[i].getSpaceUsedByIr()));
            serverLog.setCpuUsageByIr(Math.min(serverLog.getCpuUsageByIr(), logs[i].getCpuUsageByIr()));
            serverLog.setMemoryMaxByIr(Math.min(serverLog.getMemoryMaxByIr(), logs[i].getMemoryMaxByIr()));
            serverLog.setMemoryTotalByIr(Math.min(serverLog.getMemoryTotalByIr(), logs[i].getMemoryTotalByIr()));
            serverLog.setMemoryUsedByIr(Math.min(serverLog.getMemoryUsedByIr(), logs[i].getMemoryUsedByIr()));
            serverLog.setConnection(Math.min(serverLog.getConnection(), logs[i].getConnection()));
            ++i;
        }
        return serverLog;
    }

    public ServerLog() {
    }

    public ServerLog(ServerLog serverLog) {
        this.server = serverLog.server;
        this.denial = serverLog.denial;
        this.errors = serverLog.errors;
        this.spaceUsed = serverLog.spaceUsed;
        this.spaceRemain = serverLog.spaceRemain;
        this.cpuUsage = serverLog.cpuUsage;
        this.memoryUsed = serverLog.memoryUsed;
        this.spaceUsedByIr = serverLog.spaceUsedByIr;
        this.cpuUsageByIr = serverLog.cpuUsageByIr;
        this.memoryMaxByIr = serverLog.memoryMaxByIr;
        this.memoryTotalByIr = serverLog.memoryTotalByIr;
        this.memoryUsedByIr = serverLog.memoryUsedByIr;
        this.connection = serverLog.connection;
        this.day = serverLog.day;
        this.hour = serverLog.hour;
        this.minute = serverLog.minute;
        this.registered = serverLog.registered;
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.server = ByteUtil.readString((InputStream)in);
        this.denial = ByteUtil.readDouble((InputStream)in);
        this.errors = ByteUtil.readDouble((InputStream)in);
        this.spaceUsed = ByteUtil.readDouble((InputStream)in);
        this.spaceRemain = ByteUtil.readDouble((InputStream)in);
        this.cpuUsage = ByteUtil.readDouble((InputStream)in);
        this.memoryUsed = ByteUtil.readDouble((InputStream)in);
        this.spaceUsedByIr = ByteUtil.readDouble((InputStream)in);
        this.cpuUsageByIr = ByteUtil.readDouble((InputStream)in);
        this.memoryMaxByIr = ByteUtil.readDouble((InputStream)in);
        this.memoryTotalByIr = ByteUtil.readDouble((InputStream)in);
        this.memoryUsedByIr = ByteUtil.readDouble((InputStream)in);
        this.connection = ByteUtil.readDouble((InputStream)in);
        this.day = ByteUtil.readInt((InputStream)in);
        this.hour = ByteUtil.readInt((InputStream)in);
        this.minute = ByteUtil.readInt((InputStream)in);
        this.registered = new Date(ByteUtil.readLong((InputStream)in));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.registered == null ? 0 : this.registered.hashCode());
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServerLog other = (ServerLog)((Object)obj);
        if (Double.doubleToLongBits(this.connection) != Double.doubleToLongBits(other.connection)) {
            return false;
        }
        if (Double.doubleToLongBits(this.cpuUsage) != Double.doubleToLongBits(other.cpuUsage)) {
            return false;
        }
        if (Double.doubleToLongBits(this.cpuUsageByIr) != Double.doubleToLongBits(other.cpuUsageByIr)) {
            return false;
        }
        if (this.day != other.day) {
            return false;
        }
        if (Double.doubleToLongBits(this.denial) != Double.doubleToLongBits(other.denial)) {
            return false;
        }
        if (Double.doubleToLongBits(this.errors) != Double.doubleToLongBits(other.errors)) {
            return false;
        }
        if (this.hour != other.hour) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryMaxByIr) != Double.doubleToLongBits(other.memoryMaxByIr)) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryTotalByIr) != Double.doubleToLongBits(other.memoryTotalByIr)) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryUsed) != Double.doubleToLongBits(other.memoryUsed)) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryUsedByIr) != Double.doubleToLongBits(other.memoryUsedByIr)) {
            return false;
        }
        if (this.minute != other.minute) {
            return false;
        }
        if (this.registered == null ? other.registered != null : !this.registered.equals(other.registered)) {
            return false;
        }
        if (this.server == null ? other.server != null : !this.server.equals(other.server)) {
            return false;
        }
        if (Double.doubleToLongBits(this.spaceRemain) != Double.doubleToLongBits(other.spaceRemain)) {
            return false;
        }
        if (Double.doubleToLongBits(this.spaceUsed) != Double.doubleToLongBits(other.spaceUsed)) {
            return false;
        }
        return Double.doubleToLongBits(this.spaceUsedByIr) == Double.doubleToLongBits(other.spaceUsedByIr);
    }

    public final double getConnection() {
        return this.connection;
    }

    public final double getConnections() {
        return this.connection;
    }

    public final double getCpuUsage() {
        return this.cpuUsage;
    }

    public final double getCpuUsageByIr() {
        return this.cpuUsageByIr;
    }

    public final int getDay() {
        return this.day;
    }

    public final double getDenial() {
        return this.denial;
    }

    public final double getErrors() {
        return this.errors;
    }

    public final int getHour() {
        return this.hour;
    }

    public Transmitable getInstance() {
        return new ServerLog();
    }

    public final double getMemoryMaxByIr() {
        return this.memoryMaxByIr;
    }

    public final double getMemoryTotalByIr() {
        return this.memoryTotalByIr;
    }

    public final double getMemoryUsed() {
        return this.memoryUsed;
    }

    public final double getMemoryUsedByIr() {
        return this.memoryUsedByIr;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final Date getRegistered() {
        return this.registered;
    }

    public final String getServer() {
        return this.server;
    }

    public final double getSpaceRemain() {
        return this.spaceRemain;
    }

    public final double getSpaceUsed() {
        return this.spaceUsed;
    }

    public final double getSpaceUsedByIr() {
        return this.spaceUsedByIr;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeString((OutputStream)out, (String)this.server);
        ByteUtil.writeDouble((OutputStream)out, (double)this.denial);
        ByteUtil.writeDouble((OutputStream)out, (double)this.errors);
        ByteUtil.writeDouble((OutputStream)out, (double)this.spaceUsed);
        ByteUtil.writeDouble((OutputStream)out, (double)this.spaceRemain);
        ByteUtil.writeDouble((OutputStream)out, (double)this.cpuUsage);
        ByteUtil.writeDouble((OutputStream)out, (double)this.memoryUsed);
        ByteUtil.writeDouble((OutputStream)out, (double)this.spaceUsedByIr);
        ByteUtil.writeDouble((OutputStream)out, (double)this.cpuUsageByIr);
        ByteUtil.writeDouble((OutputStream)out, (double)this.memoryMaxByIr);
        ByteUtil.writeDouble((OutputStream)out, (double)this.memoryTotalByIr);
        ByteUtil.writeDouble((OutputStream)out, (double)this.memoryUsedByIr);
        ByteUtil.writeDouble((OutputStream)out, (double)this.connection);
        ByteUtil.writeInt((OutputStream)out, (int)this.day);
        ByteUtil.writeInt((OutputStream)out, (int)this.hour);
        ByteUtil.writeInt((OutputStream)out, (int)this.minute);
        ByteUtil.writeLong((OutputStream)out, (long)this.registered.getTime());
    }

    public final void setConnection(double connection) {
        this.connection = connection;
    }

    public final void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public final void setCpuUsageByIr(double cpuUsageByIr) {
        this.cpuUsageByIr = cpuUsageByIr;
    }

    public final void setDay(int day) {
        this.day = day;
    }

    public final void setDenial(double denial) {
        this.denial = denial;
    }

    public final void setErrors(double errors) {
        this.errors = errors;
    }

    public final void setHour(int hour) {
        this.hour = hour;
    }

    public final void setMemoryMaxByIr(double memoryMaxByIr) {
        this.memoryMaxByIr = memoryMaxByIr;
    }

    public final void setMemoryTotalByIr(double memoryTotalByIr) {
        this.memoryTotalByIr = memoryTotalByIr;
    }

    public final void setMemoryUsed(double memoryUsed) {
        this.memoryUsed = memoryUsed;
    }

    public final void setMemoryUsedByIr(double memoryUsedByIr) {
        this.memoryUsedByIr = memoryUsedByIr;
    }

    public final void setMinute(int minute) {
        this.minute = minute;
    }

    public final void setRegistered(Date registered) {
        this.registered = registered;
    }

    public final void setRegistered(long registered) {
        this.setRegistered(new Date(registered));
    }

    public final void setServer(String server) {
        this.server = server;
    }

    public final void setSpaceRemain(double spaceRemain) {
        this.spaceRemain = spaceRemain;
    }

    public final void setSpaceUsed(double spaceUsed) {
        this.spaceUsed = spaceUsed;
    }

    public final void setSpaceUsedByIr(double spaceUsedByIr) {
        this.spaceUsedByIr = spaceUsedByIr;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[");
        String superString = super.toString();
        if (superString.length() != 0) {
            buf.append(superString);
            buf.append(", ");
        }
        buf.append("server=");
        buf.append(this.server);
        buf.append(", ");
        buf.append("denial=");
        buf.append(this.denial);
        buf.append(", ");
        buf.append("errors=");
        buf.append(this.errors);
        buf.append(", ");
        buf.append("spaceUsed=");
        buf.append(this.spaceUsed);
        buf.append(", ");
        buf.append("spaceRemain=");
        buf.append(this.spaceRemain);
        buf.append(", ");
        buf.append("cpuUsage=");
        buf.append(this.cpuUsage);
        buf.append(", ");
        buf.append("memoryUsed=");
        buf.append(this.memoryUsed);
        buf.append(", ");
        buf.append("spaceUsedByIr=");
        buf.append(this.spaceUsedByIr);
        buf.append(", ");
        buf.append("cpuUsageByIr=");
        buf.append(this.cpuUsageByIr);
        buf.append(", ");
        buf.append("memoryMaxByIr=");
        buf.append(this.memoryMaxByIr);
        buf.append(", ");
        buf.append("memoryTotalByIr=");
        buf.append(this.memoryTotalByIr);
        buf.append(", ");
        buf.append("memoryUsedByIr=");
        buf.append(this.memoryUsedByIr);
        buf.append(", ");
        buf.append("connection=");
        buf.append(this.connection);
        buf.append(", ");
        buf.append("registered=");
        buf.append((Object)this.registered);
        buf.append(']');
        return buf.toString();
    }
}

