/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.AbstractQueryLog;
import com.diquest.ir.common.database.entity.factory.StatisticalQueryLogFactory;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public final class StatisticalQueryLog
extends AbstractQueryLog {
    private String server = "";
    private double requested;
    private double responseTime;
    private double responseTime0;
    private double responseTime1;
    private double responseTime2;
    private double responseTime3;
    private double responseTime4;
    private double responseTime5;
    private double responseTime6;
    private double responseTime7;
    private double responseTime8;
    private double responseTime9;
    private double responseTime10;
    private double cacheHit;
    private double cacheRequested;
    private int day;
    private int hour;
    private int minute;
    private long duration;

    public StatisticalQueryLog(StatisticalQueryLog log) {
        super(log);
        this.server = log.server;
        this.requested = log.requested;
        this.responseTime = log.responseTime;
        this.responseTime0 = log.responseTime0;
        this.responseTime1 = log.responseTime1;
        this.responseTime2 = log.responseTime2;
        this.responseTime3 = log.responseTime3;
        this.responseTime4 = log.responseTime4;
        this.responseTime5 = log.responseTime5;
        this.responseTime6 = log.responseTime6;
        this.responseTime7 = log.responseTime7;
        this.responseTime8 = log.responseTime8;
        this.responseTime9 = log.responseTime9;
        this.responseTime10 = log.responseTime10;
        this.cacheHit = log.cacheHit;
        this.cacheRequested = log.cacheRequested;
        this.day = log.day;
        this.hour = log.hour;
        this.minute = log.minute;
        this.duration = log.duration;
    }

    public StatisticalQueryLog() {
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.setServer(ByteUtil.readString((InputStream)in));
        this.setRequested(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime0(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime1(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime2(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime3(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime4(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime5(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime6(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime7(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime8(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime9(ByteUtil.readDouble((InputStream)in));
        this.setResponseTime10(ByteUtil.readDouble((InputStream)in));
        this.setCacheHit(ByteUtil.readDouble((InputStream)in));
        this.setCacheRequested(ByteUtil.readDouble((InputStream)in));
        this.setDay(ByteUtil.readInt((InputStream)in));
        this.setHour(ByteUtil.readInt((InputStream)in));
        this.setMinute(ByteUtil.readInt((InputStream)in));
        this.setDuration(ByteUtil.readLong((InputStream)in));
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatisticalQueryLog) {
            StatisticalQueryLog log = (StatisticalQueryLog)obj;
            return super.equals(log) && StringUtil.equals((String)this.server, (String)log.server) && this.requested == log.requested && this.responseTime == log.responseTime && this.cacheHit == log.cacheHit && this.cacheRequested == log.cacheRequested && this.duration == log.duration && this.responseTime0 == log.responseTime0 && this.responseTime1 == log.responseTime1 && this.responseTime2 == log.responseTime2 && this.responseTime3 == log.responseTime3 && this.responseTime4 == log.responseTime4 && this.responseTime5 == log.responseTime5 && this.responseTime6 == log.responseTime6 && this.responseTime7 == log.responseTime7 && this.responseTime8 == log.responseTime8 && this.responseTime9 == log.responseTime9 && this.responseTime10 == log.responseTime10;
        }
        return false;
    }

    public double getCacheHit() {
        return this.cacheHit;
    }

    public double getCacheRequested() {
        return this.cacheRequested;
    }

    public long getDuration() {
        return this.duration;
    }

    public Transmitable getInstance() {
        return new StatisticalQueryLog();
    }

    public double getRequested() {
        return this.requested;
    }

    public double getResponseTime() {
        return this.responseTime;
    }

    public double getResponseTime0() {
        return this.responseTime0;
    }

    public double getResponseTime1() {
        return this.responseTime1;
    }

    public double getResponseTime10() {
        return this.responseTime10;
    }

    public double getResponseTime2() {
        return this.responseTime2;
    }

    public double getResponseTime3() {
        return this.responseTime3;
    }

    public double getResponseTime4() {
        return this.responseTime4;
    }

    public double getResponseTime5() {
        return this.responseTime5;
    }

    public double getResponseTime6() {
        return this.responseTime6;
    }

    public double getResponseTime7() {
        return this.responseTime7;
    }

    public double getResponseTime8() {
        return this.responseTime8;
    }

    public double getResponseTime9() {
        return this.responseTime9;
    }

    public double[] getResponseTimes() {
        return new double[]{this.responseTime0, this.responseTime1, this.responseTime2, this.responseTime3, this.responseTime4, this.responseTime5, this.responseTime6, this.responseTime7, this.responseTime8, this.responseTime9, this.responseTime10};
    }

    public String getServer() {
        return this.server;
    }

    public int hashCode() {
        return super.hashCode() ^ this.server.hashCode() ^ (int)this.duration;
    }

    public void merge(StatisticalQueryLog log, double portion) {
        this.responseTime0 += log.responseTime0 * portion;
        this.responseTime1 += log.responseTime1 * portion;
        this.responseTime2 += log.responseTime2 * portion;
        this.responseTime3 += log.responseTime3 * portion;
        this.responseTime4 += log.responseTime4 * portion;
        this.responseTime5 += log.responseTime5 * portion;
        this.responseTime6 += log.responseTime6 * portion;
        this.responseTime7 += log.responseTime7 * portion;
        this.responseTime8 += log.responseTime8 * portion;
        this.responseTime9 += log.responseTime9 * portion;
        this.responseTime10 += log.responseTime10 * portion;
        this.cacheHit += log.cacheHit * portion;
        this.cacheRequested += log.cacheRequested * portion;
        if (this.requested + log.requested * portion > 0.0) {
            double weighted = (this.requested * this.responseTime + log.requested * log.responseTime * portion) / (this.requested + log.requested * portion);
            this.responseTime = Math.round(weighted);
        }
        this.requested += log.requested * portion;
    }

    public double getResponseTimeOver(int second) {
        if (second < 0 || second > 10) {
            throw new IllegalArgumentException(String.valueOf(second));
        }
        double summed = 0.0;
        switch (second) {
            case 0: {
                summed += this.responseTime0;
            }
            case 1: {
                summed += this.responseTime1;
            }
            case 2: {
                summed += this.responseTime2;
            }
            case 3: {
                summed += this.responseTime3;
            }
            case 4: {
                summed += this.responseTime4;
            }
            case 5: {
                summed += this.responseTime5;
            }
            case 6: {
                summed += this.responseTime6;
            }
            case 7: {
                summed += this.responseTime7;
            }
            case 8: {
                summed += this.responseTime8;
            }
            case 9: {
                summed += this.responseTime9;
            }
        }
        return summed += this.responseTime10;
    }

    public void merge(List logs) {
        this.merge(logs.iterator());
    }

    public void merge(Iterator logs) {
        while (logs.hasNext()) {
            this.merge((StatisticalQueryLog)logs.next());
        }
    }

    public void merge(StatisticalQueryLog log) {
        this.responseTime0 += log.responseTime0;
        this.responseTime1 += log.responseTime1;
        this.responseTime2 += log.responseTime2;
        this.responseTime3 += log.responseTime3;
        this.responseTime4 += log.responseTime4;
        this.responseTime5 += log.responseTime5;
        this.responseTime6 += log.responseTime6;
        this.responseTime7 += log.responseTime7;
        this.responseTime8 += log.responseTime8;
        this.responseTime9 += log.responseTime9;
        this.responseTime10 += log.responseTime10;
        this.cacheHit += log.cacheHit;
        this.cacheRequested += log.cacheRequested;
        if (this.requested + log.requested > 0.0) {
            double weighted;
            this.responseTime = weighted = (this.requested * this.responseTime + log.requested * log.responseTime) / (this.requested + log.requested);
        }
        this.requested += log.requested;
    }

    public void take(StatisticalQueryLog log) {
        long destRegistered = this.getRegistered();
        long srcRegistered = log.getRegistered();
        long destDuration = this.getDuration();
        long srcDuration = log.getDuration();
        double portion = StatisticalQueryLogFactory.portion(srcRegistered, srcDuration, destRegistered, destDuration);
        this.merge(log, portion);
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeString((OutputStream)out, (String)this.server);
        ByteUtil.writeDouble((OutputStream)out, (double)this.requested);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime0);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime1);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime2);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime3);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime4);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime5);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime6);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime7);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime8);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime9);
        ByteUtil.writeDouble((OutputStream)out, (double)this.responseTime10);
        ByteUtil.writeDouble((OutputStream)out, (double)this.cacheHit);
        ByteUtil.writeDouble((OutputStream)out, (double)this.cacheRequested);
        ByteUtil.writeInt((OutputStream)out, (int)this.day);
        ByteUtil.writeInt((OutputStream)out, (int)this.hour);
        ByteUtil.writeInt((OutputStream)out, (int)this.minute);
        ByteUtil.writeLong((OutputStream)out, (long)this.duration);
    }

    public void setCacheHit(double cacheHit) {
        this.cacheHit = cacheHit;
    }

    public void setCacheRequested(double cacheRequested) {
        this.cacheRequested = cacheRequested;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setRequested(double requested) {
        this.requested = requested;
    }

    public void setResponseTime(double responseTime) {
        this.responseTime = responseTime;
    }

    public void setResponseTime0(double responseTime0) {
        this.responseTime0 = responseTime0;
    }

    public void setResponseTime1(double responseTime1) {
        this.responseTime1 = responseTime1;
    }

    public void setResponseTime10(double responseTime10) {
        this.responseTime10 = responseTime10;
    }

    public void setResponseTime2(double responseTime2) {
        this.responseTime2 = responseTime2;
    }

    public void setResponseTime3(double responseTime3) {
        this.responseTime3 = responseTime3;
    }

    public void setResponseTime4(double responseTime4) {
        this.responseTime4 = responseTime4;
    }

    public void setResponseTime5(double responseTime5) {
        this.responseTime5 = responseTime5;
    }

    public void setResponseTime6(double responseTime6) {
        this.responseTime6 = responseTime6;
    }

    public void setResponseTime7(double responseTime7) {
        this.responseTime7 = responseTime7;
    }

    public void setResponseTime8(double responseTime8) {
        this.responseTime8 = responseTime8;
    }

    public void setResponseTime9(double responseTime9) {
        this.responseTime9 = responseTime9;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("[");
        String superString = super.toString();
        if (superString.length() != 0) {
            buf.append(superString);
            buf.append(", ");
        }
        buf.append("server=").append(this.server);
        buf.append(", requested=").append(this.requested);
        buf.append(", responseTime=").append(this.responseTime);
        buf.append(", responseTime0=").append(this.responseTime0);
        buf.append(", responseTime1=").append(this.responseTime1);
        buf.append(", responseTime2=").append(this.responseTime2);
        buf.append(", responseTime3=").append(this.responseTime3);
        buf.append(", responseTime4=").append(this.responseTime4);
        buf.append(", responseTime5=").append(this.responseTime5);
        buf.append(", responseTime6=").append(this.responseTime6);
        buf.append(", responseTime7=").append(this.responseTime7);
        buf.append(", responseTime8=").append(this.responseTime8);
        buf.append(", responseTime9=").append(this.responseTime9);
        buf.append(", responseTime10=").append(this.responseTime10);
        buf.append(", cacheHit=").append(this.cacheHit);
        buf.append(", cacheRequested=").append(this.cacheRequested);
        buf.append(", duration=").append(this.duration);
        buf.append(']');
        return buf.toString();
    }

    public static double[] getMinMaxAverageRequestedPerSecond(List logs) {
        if (logs.isEmpty()) {
            return new double[]{0.0, 0.0, 0.0};
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        Iterator it = logs.iterator();
        while (it.hasNext()) {
            StatisticalQueryLog l = (StatisticalQueryLog)it.next();
            double r = l.getRequested();
            if (min > r) {
                min = r;
            }
            if (max < r) {
                max = r;
            }
            sum += r / ((double)l.getDuration() / 1000.0);
        }
        return new double[]{min, max, sum / (double)logs.size()};
    }

    public final int getDay() {
        return this.day;
    }

    public final void setDay(int day) {
        this.day = day;
    }

    public final int getHour() {
        return this.hour;
    }

    public final void setHour(int hour) {
        this.hour = hour;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final void setMinute(int minute) {
        this.minute = minute;
    }
}

