/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class TrendsKeyword
extends Transmitable
implements Comparable,
Serializable {
    private static final long serialVersionUID = -8030324130856074531L;
    private String name;
    private String keyword;
    private int rank;
    private int prevRank;
    private int requested;
    private boolean fixed;
    static final Comparator REQUEST_KEYWORDS_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            TrendsKeyword o1 = (TrendsKeyword)arg0;
            TrendsKeyword o2 = (TrendsKeyword)arg1;
            int diff = o2.requested - o1.requested;
            if (diff != 0) {
                return diff;
            }
            return o1.getKeyword().compareTo(o2.getKeyword());
        }
    };

    public TrendsKeyword(TrendsKeyword trendsKeyword) {
        this.name = trendsKeyword.name;
        this.keyword = trendsKeyword.keyword;
        this.rank = trendsKeyword.rank;
        this.prevRank = trendsKeyword.prevRank;
        this.requested = trendsKeyword.requested;
        this.fixed = trendsKeyword.fixed;
    }

    public TrendsKeyword() {
    }

    public TrendsKeyword(String name, String keyword) {
        this.name = name;
        this.keyword = keyword;
    }

    public TrendsKeyword(String name, String keyword, int rank, int prevRank, int count, boolean fixed) {
        this.name = name;
        this.keyword = keyword;
        this.rank = rank;
        this.prevRank = prevRank;
        this.requested = count;
        this.fixed = fixed;
    }

    public final int getRequested() {
        return this.requested;
    }

    public final String getKeyword() {
        return this.keyword;
    }

    public final String getName() {
        return this.name;
    }

    public final int getPrevRank() {
        return this.prevRank;
    }

    public final int getRank() {
        return this.rank;
    }

    public final boolean isFixed() {
        return this.fixed;
    }

    public final void setRequested(int count) {
        this.requested = count;
    }

    public final void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public final void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setPrevRank(int prevRank) {
        this.prevRank = prevRank;
    }

    public final void setRank(int rank) {
        this.rank = rank;
    }

    public int compareTo(Object o) {
        TrendsKeyword k = (TrendsKeyword)o;
        int diff = k.requested - this.requested;
        if (diff != 0) {
            return diff;
        }
        return this.prevRank - k.prevRank;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.requested;
        result = 31 * result + (this.fixed ? 1231 : 1237);
        result = 31 * result + (this.keyword == null ? 0 : this.keyword.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.prevRank;
        result = 31 * result + this.rank;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrendsKeyword)) {
            return false;
        }
        TrendsKeyword other = (TrendsKeyword)obj;
        if (this.requested != other.requested) {
            return false;
        }
        if (this.fixed != other.fixed) {
            return false;
        }
        if (this.keyword == null ? other.keyword != null : !this.keyword.equals(other.keyword)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.prevRank != other.prevRank) {
            return false;
        }
        return this.rank == other.rank;
    }

    public String toString() {
        String TAB = ", ";
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append("name=").append(this.name).append(", ");
        buf.append("keyword=").append(this.keyword).append(", ");
        buf.append("rank=").append(this.rank).append(", ");
        buf.append("prevRank=").append(this.prevRank).append(", ");
        buf.append("count=").append(this.requested).append(", ");
        buf.append("fixed=").append(this.fixed);
        buf.append("]");
        return buf.toString();
    }

    public void deserialize(InputStream in) throws IOException {
        this.name = ByteUtil.readString((InputStream)in);
        this.keyword = ByteUtil.readString((InputStream)in);
        this.rank = ByteUtil.readInt((InputStream)in);
        this.prevRank = ByteUtil.readInt((InputStream)in);
        this.requested = ByteUtil.readInt((InputStream)in);
        this.fixed = ByteUtil.readBoolean((InputStream)in);
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.name);
        ByteUtil.writeString((OutputStream)out, (String)this.keyword);
        ByteUtil.writeInt((OutputStream)out, (int)this.rank);
        ByteUtil.writeInt((OutputStream)out, (int)this.prevRank);
        ByteUtil.writeInt((OutputStream)out, (int)this.requested);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.fixed);
    }

    public Transmitable getInstance() {
        return new TrendsKeyword();
    }

    public boolean isNull() {
        return false;
    }

    public static TrendsKeyword[] merge(TrendsKeyword[] a1, TrendsKeyword[] a2, int length, int capacity, boolean disposable) {
        Arrays.sort(a1, REQUEST_KEYWORDS_COMPARATOR);
        Arrays.sort(a2, REQUEST_KEYWORDS_COMPARATOR);
        ArrayList<TrendsKeyword> merged = new ArrayList<TrendsKeyword>(capacity);
        int i1 = 0;
        int i2 = 0;
        while (i1 < a1.length && i2 < a2.length) {
            int compare = REQUEST_KEYWORDS_COMPARATOR.compare(a1[i1], a2[i2]);
            if (compare < 0) {
                merged.add(new TrendsKeyword(a1[i1++]));
                continue;
            }
            if (compare > 0) {
                merged.add(new TrendsKeyword(a2[i2++]));
                continue;
            }
            TrendsKeyword keyword = new TrendsKeyword(a1[i1]);
            keyword.setRequested(a1[i1].requested + a2[i2].requested);
            ++i1;
            ++i2;
        }
        while (i1 < a1.length) {
            merged.add(new TrendsKeyword(a1[i1++]));
            ++i1;
        }
        while (i2 < a2.length) {
            merged.add(new TrendsKeyword(a2[i2++]));
            ++i2;
        }
        int fitted = capacity > length ? length : capacity;
        return merged.subList(0, fitted).toArray(new TrendsKeyword[capacity]);
    }
}

